<?php
  
use Illuminate\Support\Facades\Route;
  
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SponsorController;
use App\Http\Controllers\VaccinationController;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\RazorpayController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\Auth\LoginController;
use App\Models\Setting;
  
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//echo config('global.SUPER_ADMIN');

  
Route::get('/', [App\Http\Controllers\WebsiteController::class, 'home'])->name('homePage');
Route::get('/product-list/{cat}/{subcat?}', [App\Http\Controllers\WebsiteController::class, 'shopListing'])->name('shoplisting');


Route::get('/product-details/{slug}', [App\Http\Controllers\WebsiteController::class, 'productsdetails'])->name('productsdetails');
Route::post('/get-size-chart', [App\Http\Controllers\WebsiteController::class, 'getSizeChart'])->name('getSizeChart');

Route::post('/add-to-cart', [App\Http\Controllers\CartController::class, 'addToCart'])->name('addToCart');
Route::get('/cart-details', [App\Http\Controllers\CartController::class, 'cartDetails'])->name('cartDetails');
// Route::post('/cart/update-quantity/{cartItemId}/{quantityChange}',[App\Http\Controllers\CartController::class, 'updateQuantity'])->name('cart.update.quantity');


Route::post('/cart/update-quantity/{cartItemId}',[App\Http\Controllers\CartController::class, 'updateQuantity'])->name('cart.update.quantity');
Route::post('/increase-cart-item-quantity/{cart_id}', [App\Http\Controllers\CartController::class, 'increaseCartItemQuantity'])->name('increaseCartItemQuantity');
Route::post('/decrease-cart-item-quantity/{cart_id}', [App\Http\Controllers\CartController::class, 'decreaseCartItemQuantity'])->name('decreaseCartItemQuantity');
Route::post('/update-cart-item-quantity/{cart_id}', [App\Http\Controllers\CartController::class, 'updateCartItemQuantity'])->name('updateCartItemQuantity');




Route::delete('/remove-from-cart/{cart_id}', [App\Http\Controllers\CartController::class, 'removeFromCart'])->name('removeFromCart');
Route::post('/apply-coupon', [App\Http\Controllers\CartController::class, 'applyCoupon'])->name('applyCoupon');
Route::post('/update-wishlist/{product_id}', [App\Http\Controllers\CartController::class, 'updateWishlist'])->name('updateWishlist');
Route::post('/product-review/{product_id}', [App\Http\Controllers\CartController::class, 'submitProductReview'])->name('submitProductReview');
Route::post('/notify-me', [App\Http\Controllers\WebsiteController::class, 'notifyMe'])->name('notifyMe');
 
 
// autosearch
Route::get('/autocomplete-search', [App\Http\Controllers\WebsiteController::class,'autocompleteSearch']);
 
 Route::get('/about-us', [App\Http\Controllers\WebsiteController::class, 'aboutUs'])->name('aboutUs');
 Route::get('/privacy-and-policy', [App\Http\Controllers\WebsiteController::class, 'PrivacyAndPolicy'])->name('privacyAndPolicy');
Route::get('/terms-and-conditions', [App\Http\Controllers\WebsiteController::class, 'TermsAndCondition'])->name('termsAndCondition');
Route::get('/return-policy', [App\Http\Controllers\WebsiteController::class, 'ReturnPolicy'])->name('returnPolicy');
Route::get('/shipping-and-delivery', [App\Http\Controllers\WebsiteController::class, 'RefundPolicy'])->name('shippingDelivery');
Route::get('/gift-card', [App\Http\Controllers\WebsiteController::class, 'gitCard'])->name('gitCard');
Route::get('/cookie-setting', [App\Http\Controllers\WebsiteController::class, 'cookieSetting'])->name('cookieSetting');
Route::get('/customer-service', [App\Http\Controllers\WebsiteController::class, 'customerService'])->name('customerService');
Route::get('/faq', [App\Http\Controllers\WebsiteController::class, 'Faq'])->name('faq');



 Route::get('/registration-and-login', [App\Http\Controllers\WebsiteController::class, 'registrationAndLogin'])->name('registrationAndLogin');
 Route::get('/managing-my-profile', [App\Http\Controllers\WebsiteController::class, 'ManagingMyProfile'])->name('ManagingMyProfile');
Route::get('/my-favourites', [App\Http\Controllers\WebsiteController::class, 'myFavourites'])->name('myFavourites');
Route::get('/items-availability', [App\Http\Controllers\WebsiteController::class, 'itemsAvalibility'])->name('itemsAvalibility');
Route::get('/whats-my-size', [App\Http\Controllers\WebsiteController::class, 'wahtsMySize'])->name('wahtsMySize');
Route::get('/composition-and-care', [App\Http\Controllers\WebsiteController::class, 'compositionAndCare'])->name('compositionAndCare');
Route::get('/payment-method', [App\Http\Controllers\WebsiteController::class, 'paymentMethod'])->name('paymentMethod');
Route::get('/payment-security', [App\Http\Controllers\WebsiteController::class, 'paymentSecurity'])->name('paymentSecurity');
Route::get('/invoices', [App\Http\Controllers\WebsiteController::class, 'invoices'])->name('invoices');
Route::get('/order-status', [App\Http\Controllers\WebsiteController::class, 'orderStatus'])->name('orderStatus');
Route::get('/change-or-cancel', [App\Http\Controllers\WebsiteController::class, 'changeOrCancel'])->name('changeOrCancel');
Route::get('/issue-with-my-orer', [App\Http\Controllers\WebsiteController::class, 'issueWithMyOrder'])->name('issueWithMyOrder');
Route::get('/exchange', [App\Http\Controllers\WebsiteController::class, 'exchange'])->name('exchange');
Route::get('/email-verification-policy', [App\Http\Controllers\WebsiteController::class, 'emailVerificationPolicy'])->name('emailVerificationPolicy');


Route::get('/ulogin', [App\Http\Controllers\WebsiteController::class, 'loginForm'])->name('LoginForm');
Route::get('/signup', [App\Http\Controllers\WebsiteController::class, 'RegistrationForm'])->name('RegistrationForm');
Route::post('/signup-user', [App\Http\Controllers\WebsiteController::class, 'register'])->name('registerUser');
Route::post('/user-login', [App\Http\Controllers\WebsiteController::class, 'login'])->name('saveUserLogin');

Route::get('/guest-signup', [App\Http\Controllers\WebsiteController::class, 'guestSignUp'])->name('guestSignUp');
 Route::post('/save-guest-address', [App\Http\Controllers\WebsiteController::class, 'SaveNewGuestAddress'])->name('SaveNewGuestAddress');

 Route::post('/u-logout',[App\Http\Controllers\WebsiteController::class, 'userLogout'])->name('userLogout'); 
Route::get('/payment', [RazorpayController::class, 'index']);
Route::post('/payment/process',[RazorpayController::class, 'processPayment']);
Route::any('/payment/success', [RazorpayController::class, 'paymentSuccess']);
Route::any('/payment/failure', [RazorpayController::class, 'paymentFailure']);



Route::POST('/submit-order',[App\Http\Controllers\CartController::class, 'submitOrder'])->name('submitOrder');
Route::any('phonepe-response',[PhonePeController::class,'response2'])->name('response');

Route::get('/thank-you',[App\Http\Controllers\CartController::class, 'ThankYou'])->name('ThankYou');

Route::get('/reset-password', [App\Http\Controllers\HomeController::class, 'UserResetPasswordForm'])->name('UserResetPasswordForm');

Route::post('/send-reset-password-link', [App\Http\Controllers\HomeController::class, 'SendUserResetPasswordLink'])->name('SendUserResetPasswordLink');

Route::get('/change-password/{token}', [App\Http\Controllers\HomeController::class, 'getUserResetPasswordForm'])->name('getUserResetPasswordForm');

Route::post('change-password', [App\Http\Controllers\HomeController::class, 'resetPassword'])->name('resetUserPassword');
// end product route front

Auth::routes();
  
/*------------------------------------------
--------------------------------------------
All Normal Users Routes List
--------------------------------------------
--------------------------------------------*/
Route::post('/razorpay/initiate-payment', [RazorpayController::class,'initiatePayment']);

Route::get('/razorpay/checkout', [RazorpayController::class, 'checkout'])->name('checkout');
Route::post('/razorpay/payment', [RazorpayController::class, 'payment'])->name('payment');
Route::middleware(['auth', 'user-access:0'])->group(function () {
  Route::get('/checkout',[App\Http\Controllers\CartController::class, 'checkout'])->name('checkout');
    Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::get('/dashboard', [App\Http\Controllers\UserController::class, 'userDashboard'])->name('userDashboard');
    Route::get('/my-account', [App\Http\Controllers\UserController::class, 'myAccount'])->name('myAccount');
  Route::post('/update-account', [App\Http\Controllers\UserController::class, 'updateMyAccount'])->name('updateMyAccount');

   Route::get('/my-orders', [App\Http\Controllers\UserController::class, 'myOrders'])->name('myOrders');


   Route::get('/order-details/{order_id}', [App\Http\Controllers\UserController::class, 'orderDetails'])->name('orderDetails');

    Route::get('/my-wishlist', [App\Http\Controllers\UserController::class, 'myWishlist'])->name('myWishlist');

    Route::get('download-invoice/{id}', [App\Http\Controllers\UserController::class, 'DownloadInvoice'])->name('DownloadInvoice');

   Route::get('/change-account-password', [App\Http\Controllers\UserController::class, 'changeMyPassword'])->name('changeMyPassword');
   Route::post('/update-account-password', [App\Http\Controllers\UserController::class, 'updateMyPassword'])->name('updateMyPassword');

   Route::get('/my-address-book', [App\Http\Controllers\UserController::class, 'myAddressBook'])->name('myAddressBook');
  Route::get('/add-new-address', [App\Http\Controllers\UserController::class, 'addNewAddress'])->name('addNewAddress');

   Route::post('/save-customer-address', [App\Http\Controllers\UserController::class, 'SaveNewCustomerAddress'])->name('SaveNewCustomerAddress');

    Route::get('/edit-address-book/{id}', [App\Http\Controllers\UserController::class, 'editMyAddressBook'])->name('editMyAddressBook');

   Route::post('/update-customer-address/{id}', [App\Http\Controllers\UserController::class, 'updateMyAddressBook'])->name('updateMyAddressBook');

  Route::post('/delete-customer-address/{id}', [App\Http\Controllers\UserController::class, 'DeleteMyAddressBook'])->name('DeleteMyAddressBook');
});
  
  Route::get('/logout',[AdminController::class, 'adminlogout'])->name('adminlogout'); 
  
  Route::get('/admin/login',[LoginController::class, 'adminLogin'])->name('adminLogin'); 
  Route::post('/admin/login',[LoginController::class, 'adminLoginSubmit'])->name('adminLoginSubmit'); 
  Route::post('/logout',[AdminController::class, 'adminlogout'])->name('adminlogout'); 
/*------------------------------------------
--------------------------------------------
All Admin Routes List
--------------------------------------------
--------------------------------------------*/
Route::middleware(['auth', 'user-access:1'])->group(function () {
  
    Route::get('/admin/home', [HomeController::class, 'adminHome'])->name('admin.home');
 
    
     Route::get('/admin/user/{id}/details',[AdminController::class, 'viewUserDetails'])
    ->name('admin.user.details');
    Route::get('/admin/change-status/{id}/{status}', [AdminController::class, 'changeStatus'])->name('admin.status');
    
    Route::get('/admin/category', [AdminController::class, 'listCategory'])->name('category.list');
    Route::get('/admin/add-category', [AdminController::class, 'addCategory'])->name('category.add');
    Route::post('/admin/save-category', [AdminController::class, 'saveCategory'])->name('category.save');
    Route::get('/admin/edit-category/{id}',  [AdminController::class, 'editCategory'])->name('category.edit');
    Route::post('/admin/update-category/{id}',  [AdminController::class, 'updateCategory'])->name('category.update');
    
    
    Route::get('/admin/banner', [AdminController::class, 'listBanner'])->name('banner.list');
    Route::get('/admin/add-banner', [AdminController::class, 'addBanner'])->name('banner.add');
    Route::post('/admin/save-banner', [AdminController::class, 'saveBanner'])->name('banner.save');
    Route::get('/admin/edit-banner/{id}',  [AdminController::class, 'editBanner'])->name('banner.edit');
    Route::post('/admin/update-banner/{id}',  [AdminController::class, 'updateBanner'])->name('banner.update');
      Route::get('/admin/update-banner-status/{id}/{status}',  [AdminController::class, 'updateBannerStatus'])->name('banner.update.status');
    Route::post('/products/mark-blackdress/{slug}', [ProductController::class, 'markBlackdress'])->name('products.markBlackdress');
     Route::get('/products/list/{slug}',  [ProductController::class, 'showIndexPpage'])->name('showIndexPpage');
     Route::get('/admin/generate-barcodes', [ProductController::class, 'generateBarcodes']);
    Route::get('/admin/slider', [AdminController::class, 'listSlider'])->name('slider.list');
    Route::get('/admin/add-slider', [AdminController::class, 'addSlider'])->name('slider.add');
    Route::post('/admin/save-slider', [AdminController::class, 'saveSlider'])->name('slider.save');
    Route::get('/admin/edit-slider/{id}',  [AdminController::class, 'editSlider'])->name('slider.edit');
    Route::post('/admin/update-slider/{id}',  [AdminController::class, 'updateSlider'])->name('slider.update');
    
    Route::get('/admin/sub-category', [AdminController::class, 'listSubCategory'])->name('subcategory.list');
    Route::get('/admin/add-sub-category', [AdminController::class, 'addSubCategory'])->name('subcategory.add');
    Route::post('/admin/save-sub-category', [AdminController::class, 'saveSubCategory'])->name('subcategory.save');
    Route::get('/admin/edit-sub-category/{id}',  [AdminController::class, 'editSubCategory'])->name('subcategory.edit');
    Route::post('/admin/update-sub-category/{id}',  [AdminController::class, 'updateSubCategory'])->name('subcategory.update');
    
    
    Route::get('/admin/fabric', [AdminController::class, 'listFabric'])->name('fabric.list');
    Route::get('/admin/add-fabric', [AdminController::class, 'addFabric'])->name('fabric.add');
    Route::post('/admin/save-fabric', [AdminController::class, 'saveFabric'])->name('fabric.save');
    Route::get('/admin/edit-fabric/{id}',  [AdminController::class, 'editFabric'])->name('fabric.edit');
    Route::post('/admin/update-fabric/{id}',  [AdminController::class, 'updateFabric'])->name('fabric.update');
    
    
    Route::get('/admin/coupon', [AdminController::class, 'listCoupon'])->name('coupon.list');
    Route::get('/admin/add-coupon', [AdminController::class, 'addCoupon'])->name('coupon.add');
    Route::post('/admin/save-coupon', [AdminController::class, 'saveCoupon'])->name('coupon.save');
    Route::get('/admin/edit-coupon/{id}',  [AdminController::class, 'editCoupon'])->name('coupon.edit');
    Route::post('/admin/update-coupon/{id}',  [AdminController::class, 'updateCoupon'])->name('coupon.update');
    
    
    Route::get('/admin/color', [AdminController::class, 'listColor'])->name('color.list');
    Route::get('/admin/add-color', [AdminController::class, 'addColor'])->name('color.add');
    Route::post('/admin/save-color', [AdminController::class, 'saveColor'])->name('color.save');
    Route::get('/admin/edit-color/{id}',  [AdminController::class, 'editColor'])->name('color.edit');
    Route::post('/admin/update-color/{id}',  [AdminController::class, 'updateColor'])->name('color.update');
    
    
    
    Route::get('/admin/size', [AdminController::class, 'listSize'])->name('size.list');
    Route::get('/admin/add-size', [AdminController::class, 'addSize'])->name('size.add');
    Route::post('/admin/save-size', [AdminController::class, 'saveSize'])->name('size.save');
    Route::get('/admin/edit-size/{id}',  [AdminController::class, 'editSize'])->name('size.edit');
    Route::post('/admin/update-size/{id}',  [AdminController::class, 'updateSize'])->name('size.update');
    
    Route::get('/set-currency/{currency}', [AdminController::class, 'setCurrency'])->name('set.currency');
    
    

    Route::get('/admin/new-product', [ProductController::class, 'addProduct'])->name('admin.new.product');
    Route::post('/admin/product', [ProductController::class, 'saveProduct'])->name('admin.save.product');
    Route::get('/admin/edit-product/{id}',  [ProductController::class, 'editProduct'])->name('admin.edit.product');
    Route::get('/admin/view-product/{id}',  [ProductController::class, 'viewProduct'])->name('admin.view.product');
    Route::delete('/admin/products/{id}', [ProductController::class, 'deleteProduct'])->name('admin.delete.product');
     Route::put('/admin/product/{id}/status',[ProductController::class, 'updateProductStatus'])->name('admin.product.status');

    Route::get('/admin/list-product',  [ProductController::class, 'listProduct'])->name('admin.list.product');
    Route::post('/admin/update-product/{id}',  [ProductController::class, 'updateProduct'])->name('admin.update.product');
    Route::post('ajaxRequest/module',  [ProductController::class, 'addMoreModuleSection'])->name('ajaxRequest.addMoreModuleSection');
    Route::post('ajaxRequest/module-question', [ProductController::class, 'addMoreModuleQuestionSection'])->name('ajaxRequest.addMoreModuleQuestionSection');
     Route::post('ajaxRequest/module-question-usd', [ProductController::class, 'addMoreModuleQuestionSectionUsd'])->name('ajaxRequest.addMoreModuleQuestionSectionUsd');
    Route::post('ajaxRequest/check-sku', [ProductController::class, 'chkSkuExist'])->name('ajaxRequest.chk_sku');
   Route::get('/admin/update-product-status/{id}/{status}',  [ProductController::class, 'updateProductStatus'])->name('admin.status.product');
   Route::get('delete-image/{id}', [ProductController::class, 'deleteOptionImage'])->name('deleteOptionImage');
   Route::post('ajaxRequest/delete-question-answer', [ProductController::class, 'deleteQuestionAnswer'])->name('ajaxRequest.deleteQuestionAnswer');
   
    Route::post('fetch-subcategories', [ProductController::class, 'fetchSubcategories'])->name('fetchSubcategories');
    Route::get('/admin/orders',  [AdminController::class, 'listOrders'])->name('admin.list.orders');
    Route::get('/admin/order-detail/{id}',  [AdminController::class, 'orderDetail'])->name('admin.detail.order');
    Route::post('/update-status/{id}', [AdminController::class, 'UpdateorderStatus'])->name('update.order.status');

    Route::get('/admin/invoices',  [AdminController::class, 'listInvoices'])->name('admin.list.invoice');
    Route::get('/admin/invoice-detail/{id}',  [AdminController::class, 'invoiceDetail'])->name('admin.detail.invoice');
    
    Route::get('/admin/reels',  [AdminController::class, 'listReels'])->name('admin.list.reels');
    Route::get('/admin/update-reels-status/{id}/{status}',  [AdminController::class, 'updateReelsStatus'])->name('admin.status.reels');
     
    Route::get('/admin/coming-soon',  [AdminController::class, 'listComingSoonData'])->name('admin.list.comingSoon');
    
    Route::get('/admin/users',  [AdminController::class, 'listUsers'])->name('admin.list.user');
    Route::put('/admin/user/status/{id}',[AdminController::class,'updateStatus'])->name('admin.user.status');
    Route::put('/admin/coupon/status/{id}',[AdminController::class,'updateCouponStatus'])->name('admin.coupon.status');
    Route::get('/admin/edit-user/{id}', [AdminController::class, 'editUser'])->name('user.edit');
    Route::post('/admin/update-user/{id}',  [AdminController::class, 'updateUser'])->name('user.update');
    Route::get('/admin/reviews',  [AdminController::class, 'listReview'])->name('admin.list.review');
    Route::get('/admin/update-review-status/{id}/{status}',  [AdminController::class, 'updateReviewStatus'])->name('admin.status.review');

});
  
/*------------------------------------------
--------------------------------------------
All Admin Routes List
--------------------------------------------
--------------------------------------------*/
Route::middleware(['auth', 'user-access:2'])->group(function () {
  
    Route::get('/partner/home', [HomeController::class, 'learningPartnerHome'])->name('partner.home');
    Route::get('partner/learning-module-list', [AdminController::class,'AllModuleList'])->name('partner.AllModuleList');
     Route::get('/partner/view-learning-module/{id}',  [AdminController::class, 'viewLearningModule'])->name('partner.view.learning');
     Route::get('partner/purchased-product-list/{type}', [AdminController::class,'listPurchasedCourse'])->name('partner.list.user');
     Route::get('partner/analytics', [AdminController::class,'listAnalytics'])->name('partner.list.analytics');
     Route::get('partner/query', [CompanyController::class,'addQuery'])->name('partner.add.query');
     Route::post("partner-save-query",[CompanyController::class,'SavePartnerQuery'])->name('partner.save.query');
     Route::get('/partner/view-learning-module-review/{id}',  [AdminController::class, 'viewLearningModuleReview'])->name('partner.review.learning');
     Route::get('/export-learning-partner/{status}', [AdminController::class,'exportLaerningPartner'])->name('exportPartner');
    Route::get('/export-vendor/{status}', [AdminController::class,'exportVendor'])->name('exportVendor');
    Route::get('/export-learning-module/{status}', [AdminController::class,'exportLaerningModule'])->name('exportLearningModule');
    Route::get('/export-user/{status}', [AdminController::class,'exportUser'])->name('exportUser');
    Route::get('/export-purchased-course/{status}', [AdminController::class,'exportPurchasedCourse'])->name('exportPurchasedCourse');


});

Route::middleware(['auth', 'user-access:3'])->group(function () {
  
    Route::get('/sponsor/home', [HomeController::class, 'sponsorHome'])->name('sponsor.home');
    Route::get('/sponsor/available-coupons', [SponsorController::class, 'availableCoupons'])->name('available.coupon.list');
    Route::get('/sponsor/used-coupons', [SponsorController::class, 'usedCoupons'])->name('used.coupon.list');
    
    Route::get('/sponsor/course-list', [SponsorController::class, 'listCourse'])->name('course.list');
    Route::get('/sponsor/view-course/{id}', [SponsorController::class, 'viewCourse'])->name('course.view');
    Route::get('/sponsor/view-learning-module-review/{id}',  [AdminController::class, 'viewLearningModuleReview'])->name('sponsor.review.learning');
    
     Route::get('sponsor/query', [SponsorController::class,'addQuery'])->name('sponsor.add.query');
     Route::post("sponsor-save-query",[SponsorController::class,'SavePartnerQuery'])->name('sponsor.save.query');
    
});
 