<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\RegisterController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\SponsorController;
use App\Http\Controllers\API\ProductController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
  
Route::controller(RegisterController::class)->group(function(){
    Route::post('check-mobile-number', 'checkMobileExistOrNot');
    Route::post('login', 'login');
    Route::get('get-slider-data', 'getSliderData');
    Route::get('get-home-banner', 'getHomePageBannerData');
    Route::get('get-category-page-top-banner', 'getCategoryPageTopBannerData');
    Route::get('get-swipe-screen-banner', 'getSwipePageBannerData');
    Route::get('get-login-banner', 'getLoginPageBannerData');
    Route::post('registerapi', 'registerDataApi');
    Route::get('get-all-countries', 'getCountries');
    Route::get('get-all-states/{id}', 'getStates');
    Route::get('get-all-cities/{id}', 'getCities');
    Route::post('password/email',  'sendOtpOnMail');
    Route::post('password/code/check', 'checkOtp');
    Route::post('password/reset', 'passwordReset');
    
      Route::get('size-list', 'getAllSizes');
});
 Route::get('get-all-category', [ProductController::class,'getAllCategory']);
 Route::get('get-all-sub-category/{cat_id}', [ProductController::class,'getAllSubCategory']);
  Route::get('get-all-new-product', [ProductController::class,'getAllNewProduct']);
 Route::get('get-all-product', [ProductController::class,'getAllProduct']);
 Route::get('get-related-product/{sub_cat_id}', [ProductController::class,'getAllRelatedProduct']);
     Route::get('get-product-detail/{id}', [ProductController::class,'getProductDetail']);
  
 
  
      Route::get('get-product-rating-review/{product_id}', [UserController::class,'getProductRatingReview']);
    Route::get('get-user-reel-data', [UserController::class,'getUserReelData']);
    Route::middleware('auth:sanctum')->group( function () {
        
     Route::post('add-to-wishlist', [UserController::class,'addProductToWishlist']);
     Route::get('get-user-wishlist', [UserController::class,'getUserwishList']);
     Route::delete('remove-wishlist/{id}', [UserController::class, 'removeWishlistItem']);
        
        
           Route::post('add-to-cart', [UserController::class,'addProductToCart']);
     Route::get('get-user-cart-list', [UserController::class,'getUserCartList']);
     Route::delete('remove-cart-item/{id}', [UserController::class, 'removeCartItem']);
     
     
     Route::post('increase-product-Qty', [UserController::class, 'productQtyIncrease']);
     Route::post('decrease-product-Qty', [UserController::class, 'productQtyDecrease']);
     
    
     Route::get('user-detail', [UserController::class, 'userDetail']);
    Route::get('cart/total-amount', [UserController::class, 'getTotalAmount']);

    Route::post('update-profile', [UserController::class,'updateUserProfile']);
    Route::post('update-user-image', [UserController::class,'updateUserImage']);
    Route::get('user-address', [UserController::class,'getAllUserAddress']);
    Route::post('add-user-address', [UserController::class,'addUserAddress']);
    Route::get('edit-user-address/{id}', [UserController::class,'editUserAddress']);
    Route::post('update-user-address', [UserController::class,'updateUserAddress']);
    Route::delete('delete-address/{id}', [UserController::class, 'deleteUserAddress']);
    
    Route::post('add-rating-review', [UserController::class,'addRatingReviewForProduct']);
      Route::post('place-order', [UserController::class, 'placeOrder']);
     Route::post('apply-coupon', [UserController::class,'applyCouponCode']);
    Route::post('change-password', [UserController::class,'changePassword']);
      Route::get('get-all-orders', [UserController::class,'getAllOrders']);
     Route::get('get-order-detail/{id}', [UserController::class,'getOrderDetail']);
    
    Route::post('/logout', [RegisterController::class, 'logout']);
    
     Route::get('notifications-list', [UserController::class,'userNotificationsList']);
    Route::post('delete-all-notification', [UserController::class,'deleteAllNotification']);
    Route::get('read-notification/{notification_id}', [UserController::class,'readNotification']);
    
});
