@extends('front.layouts.app')

@section('content')
 <div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container">
					<a href="{{route('homePage')}}" class="sc_hover">Home</a> / <a href="{{ route('shoplisting','all')}}" class="sc_hover">Products</a>  / <span class="color_light">{{$product->name}}</span>
				</div>
			</div>
			<!--main content-->
			<div class="page_section_offset">
				<div class="container">
					<section>
						<main class="clearfix m_xs_bottom_30">
							<div class="row">
								<div class="col-lg-5 col-md-5 col-sm-5 m_bottom_20 m_xs_bottom_15">
								    
									<div class="wrapper">
										<div class="d_block relative r_image_container">
											<img id="zoom" src="{{env('APP_URL')}}{{$product->front_image}}" alt="" data-zoom-image="{{env('APP_URL')}}{{$product->front_image}}">
											<!--<div class="product_label fs_ex_small circle color_white bg_lbrown t_align_c vc_child tt_uppercase"><i class="d_inline_m">Sale!</i></div>-->
										</div>
										<!--thumbnails-->
										<div class="product_thumbnails_wrap relative">
											<div class="owl-carousel" id="thumbnails" data-nav="thumbnails_product_" data-owl-carousel-options='{
												"responsive" : {
													"0" : {
														"items" : 3
													},
													"321" : {
														"items" : 5
													},
													"769" : {
														"items" : 3
													},
													"992" : {
														"items" : 5
													}
												},
												"stagePadding" : 40,
												"margin" : 10,
												"URLhashListener" : false
											}'>	
											
											        <a href="{{env('APP_URL')}}{{$product->front_image}}" data-image="{{env('APP_URL')}}{{$product->front_image}}" data-zoom-image="{{env('APP_URL')}}{{$product->front_image}}" class="d_block">
    													<img src="{{env('APP_URL')}}{{$product->front_image}}" alt="">
    												</a>
                                            
                                                   @if(!empty($product->images))
                                                       @foreach($product->images as $imageData)
                                                            <a href="{{env('APP_URL')}}{{$imageData->image}}" data-image="{{env('APP_URL')}}{{$imageData->image}}" data-zoom-image="{{env('APP_URL')}}{{$imageData->image}}" class="d_block">
                													<img src="{{env('APP_URL')}}{{$imageData->image}}" alt="">
                												</a>
                                                        
                                                         @endforeach
                                                 @endif
											
											</div><!--
											<button class="thumbnails_product_prev black_hover type_2 button_type_4 grey state_2 tr_all d_block vc_child"><i class="fa fa-angle-left d_inline_m"></i></button>
											<button class="thumbnails_product_next black_hover type_2 button_type_4 grey state_2 tr_all d_block vc_child"><i class="fa fa-angle-right d_inline_m"></i></button>-->
										</div>
									</div>
								</div>
								<div class="col-lg-7 col-md-7 col-sm-7 m_bottom_20">
									<div class="wrapper">
										<h3 class="second_font m_bottom_3 f_left product_title"><a href="{{route('productsdetails',$product->id)}}" class="sc_hover">{{$product->name}}</a></h3>
										<div class="clearfix f_right">
											<a href="#" class="t_align_c button_type_4 black_hover grey state_2 tr_all d_block f_left vc_child m_right_5"><i class="fa fa-angle-left d_inline_m"></i></a>
											<a href="#" class="t_align_c button_type_4 black_hover grey state_2 tr_all d_block f_left vc_child"><i class="fa fa-angle-right d_inline_m"></i></a>
										</div>
									</div>
									<div class="relative m_bottom_18">
										<ul class="rating_list wrapper hr_list d_inline_m tr_all m_right_5">
										 <div class="rating-stars">
                                            @for($i = 1; $i <= 5; $i++)
                                                @if($i <= $averageRating)
                                                    <span class="filled-star" style="color: #d6a916;">&#9733;</span>
                                                @else
                                                    <span class="empty-star">&#9733;</span>
                                                @endif
                                            @endfor
                                        </div>
										</ul>
										<span class="color_light d_inline_m m_top_2">
											<a href="#" class="sc_hover fs_medium fw_light">{{ $totalReviews }} Review(s)</a>
										</span>
									</div>
									<ul class="m_bottom_14">
										<li class="m_bottom_3"><span class="project_list_title second_font d_inline_b">Manufacturer:</span> <span class="color_dark fw_light">{{$product->manufacturer}}</span></li>
										<li class="m_bottom_3"><span class="project_list_title second_font d_inline_b">Category Name:</span> <span class="scheme_color fw_light">{{$product->cat_name}}</span> </li>
										<li class="m_bottom_3"><span class="project_list_title second_font d_inline_b">Product Code:</span> <span class="fw_light">{{$product->sku_no}}</span></li>
										<li class="m_bottom_3"><span class="project_list_title second_font d_inline_b">Product Material:</span> <span class="fw_light">{{$product->material}}</span></li>
											<li class="m_bottom_3"><span class="project_list_title second_font d_inline_b">Product Weight:</span> <span class="fw_light">{{$product->weight}}</span></li>
									</ul>
									<hr class="divider_light m_bottom_15">
									<p class="fw_light m_bottom_14 color_grey">{!! $product->description !!}</p>
									<div class="product_options m_bottom_20">
										<b class="second_font d_block m_bottom_10">Available Options</b>
										<p class="second_font m_bottom_10">Size:</p>
										<!--<div class="styled_select size_select relative m_bottom_15">
											<div class="select_title type_2 fs_medium fw_light color_light relative d_none tr_all">Select Size</div>
											<select>
												<option value="Small">Small</option>
												<option value="Medium">Medium</option>
												<option value="Large">Large</option>
											</select>
											<ul class="options_list d_none tr_all hidden bg_grey_light_2"></ul>
										</div>-->
										<!--<div class="styled_select size_select relative m_bottom_15">-->
										<!--	<div class="select_title type_2 fs_medium fw_light color_light relative d_none tr_all">Queen</div>-->
										
                                        <ul class="hr_list m_bottom_17 " id="size-list">
											 @if(!empty($product->sizes))
                                                   @foreach($product->sizes as $key => $sizeData)
                                                   <?php //echo '<pre/>';print_r($sizeData);die;?>
                                                            <li   class="m_right_5 m_bottom_3 {{ $key == 0 ? 'active' : '' }}"><a class="color_swathes color_button tr_all {{ $key == 0 ? 'active' : '' }} " href="javascript:void(0);" data-size="{{$sizeData->id}}">{{$sizeData->size->name}}</a></li>
                    
                                                    
                                                     @endforeach
                                             @endif
										</ul>
										  <span class="text-danger validation-err" id="Select-size-err"></span>
										<!--	<select>-->
										<!--		<option value="Queen">Queen</option>-->
										<!--		<option value="King">King</option>-->
										<!--		<option value="Grand">Grand</option>-->
										<!--	</select>-->
										<!--	<ul class="options_list d_none tr_all hidden bg_grey_light_2"></ul>-->
										<!--</div>-->
										
<!--										<p class="second_font">Color:</p>-->
<!--										<ul class="hr_list m_bottom_17">-->
<!--											<li class="m_right_5 m_bottom_3"><button class="color_button tr_all" style="background-color:{{$product->color->code}};"></button></li>-->
<!--										</ul>-->
										

                                            <div style="display: flex; align-items: center;">
                                                <div>
                                                    <p class="second_font" style="margin-bottom: 0;">Color:</p>
                                                    <ul class="hr_list" style="margin-bottom: 0;">
                                                        <li style="margin-right: 5px;"><button class="color_button tr_all" style="background-color:{{$product->color->code}};"></button></li>
                                                    </ul>
                                                </div>
                                               
                                               <div style="margin-left: auto; display: flex; align-items: center;">
                                                    @if(!empty($product->us_link))
                                                    <h4 class="second_font" style="margin-left: 10px; margin-bottom: 0;">Visit For US & Canada:</h4>
                                                   
                                                        <button class="button_type_2 d_block f_sm_none m_sm_bottom_3 t_align_c lbrown state_2 tr_all second_font fs_medium tt_uppercase f_left m_right_3" onclick="window.open('{{$product->us_link}}', '_blank')">Buy Now</button>
                                                    @endif
                                                </div>



                                            </div>


										

										<hr class="divider_light">
										<footer class="bg_grey_light_2">
											<div class="fs_big second_font m_bottom_17"><s class="color_light">  @if($product->sizes[0]->price > $product->sizes[0]->sell_price)
                                            ₹{{$product->sizes[0]->price}}
                                        @endif</s> <b class="scheme_color price_box"> ₹{{$product->sizes[0]->sell_price}}</b></div>
											<div class="clearfix">
												<div class="quantity clearfix t_align_c f_left f_md_none m_right_10 m_md_bottom_3">
													<button class="f_left d_block minus black_hover tr_all bg_white">-</button>
													<input type="text" value="1" name="quantity" id="quantity" readonly="" class="f_left color_light">
													<button class="f_left d_block black_hover tr_all bg_white">+</button>
												</div>
												<br class="d_md_block d_none">
												
												 @if($isInCart)
                                            <!-- Product is already in the cart, hide the Add to Cart button -->
                                            <button data-popup="#add_to_cart_popup" data-popup-transition-in="bounceInUp" data-popup-transition-out="bounceOutUp" class="button_type_2 d_block f_sm_none m_sm_bottom_3 t_align_c lbrown state_2 tr_all second_font fs_medium tt_uppercase f_left m_right_3 product_button" onclick="window.location.href='{{ route('cartDetails') }}'">
                                                <i class="fa fa-shopping-cart d_inline_m m_right_9"></i>Buy Now
                                            </button>
                                        @else
                                            <!-- Product is not in the cart, hide the Buy Now button -->
                                            <button data-popup="#add_to_cart_popup" id="add-to-cart-btn" product_id="{{ $product->id }}" data-popup-transition-in="bounceInUp" data-popup-transition-out="bounceOutUp" class="button_type_2 d_block f_sm_none m_sm_bottom_3 t_align_c lbrown state_2 tr_all second_font fs_medium tt_uppercase f_left m_right_3 product_button">
                                                <i class="fa fa-shopping-cart d_inline_m m_right_9"></i>Add To Cart
                                            </button>
                                        @endif
												<!--<button data-popup="#add_to_cart_popup"  id="add-to-cart-btn"  product_id="{{ $product->id }}" data-popup-transition-in="bounceInUp" data-popup-transition-out="bounceOutUp" class="button_type_2 d_block f_sm_none m_sm_bottom_3 t_align_c lbrown state_2 tr_all second_font fs_medium tt_uppercase f_left m_right_3 product_button"><i class="fa fa-shopping-cart d_inline_m m_right_9"></i>Add To Cart</button>-->
											<!--	 <button type="button" class="default-btn add-cart" id="add-to-cart-btn"  product_id="{{ $product->id }}"><i class="fas fa-cart-plus"></i> Add to Cart</button>&nbsp;&nbsp;-->
												<br class="d_sm_block d_none">
												
												
												<!--@if(wishlist_status($product->id))-->
            <!--                                        <a href="javascript:void(0);" title="Remove from wishlist" class="wishlist update-wishlist-btn optional-btn button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative" product_id="{{$product->id}}" >-->
            <!--                                        <i class="fa fa-heart"></i> Remove to Wishlist-->
            <!--                                        </a>-->
            <!--                                    @else-->
            <!--                                        <a href="javascript:void(0);" title="Add to wishlist" class="wishlist update-wishlist-btn optional-btn button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative" product_id="{{$product->id}}"><i class="fa fa-heart"></i> -->
                                                    
            <!--                                        </a>-->
                                                
            <!--                                    @endif-->
												<!--<button class="button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative"><i class="fa fa-arrow-right fs_small d_inline_m"></i><i class="fa fa-arrow-left fs_small d_inline_m"></i><span class="tooltip top fs_small color_white hidden animated" data-show="fadeInDown" data-hide="fadeOutUp">Add to Compare</span></button>
												<button class="button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative"><i class="fa fa-question fs_ex_large d_inline_m"></i><span class="tooltip top fs_small color_white hidden animated" data-show="fadeInDown" data-hide="fadeOutUp">Ask a Question</span></button>-->
											</div>
										</footer>
									</div>
								
								</div>
							</div>
						</main>
						<!--tabs-->
						<div class="tabs styled_tabs m_bottom_18 m_top_10">
							<nav class="second_font">
								<ul class="hr_list">
									<!--<li class="m_right_3"><a href="#tab1" class="color_light border_light_3 d_block">Description</a></li>-->
									<li class="m_right_3"><a href="#tab2" class="color_light border_light_3 d_block">How To Use</a></li>
									<li class="m_right_3"><a href="#tab3" class="color_light border_light_3 d_block">Reviews</a></li>
								</ul>
							</nav>
							<hr class="d_xs_none">
							<!--<div id="tab1" class="fw_light tab_content">-->
							<!--	<p class="m_bottom_13"></p>-->
							<!--</div>-->
							<div id="tab2" class="tab_content">
								<ul>
								
									<li><div class="sp_label second_font d_inline_b m_right_8 use_li">{!! $product->how_to_use !!}</div> <span class="fw_light"></br></span><hr class="divider_light m_top_7 m_bottom_7"></li>
								</ul>
							</div>
							<div id="tab3" class="tab_content">
							    @if(!empty($product->reviews))
							    @foreach($product->reviews as $productReviewData)
    								<div class="m_bottom_20">
    									<div class="m_bottom_12 clearfix">
    										<div class="f_left lh_small  f_xs_none">
    										    <?php 
    										        $date = strtotime($productReviewData->created_at);
    										    ?>
    											<a href="#" class="second_font color_default sc_hover d_inline_b v_align_b">{{$productReviewData->user->name}},</a> <span class="color_light fs_medium d_inline_b v_align_b fw_light">{{date('d F Y', $date)}}</span>
    										</div>
    										<div class="f_right f_xs_none">
    											<div class="rating-stars">
                                            @for($i = 1; $i <= 5; $i++)
                                                @if($i <= $productReviewData->rating)
                                                    <span class="filled-star" style="color: #d6a916;">&#9733;</span>
                                                @else
                                                    <span class="empty-star">&#9733;</span>
                                                @endif
                                            @endfor
                                        </div>
    										</div>
    									</div>
    									<p class="fw_light">{{$productReviewData->review}}</p>
    								</div>
								@endforeach
								@else
								    No Reviews Yet.
								@endif
								<hr class="divider_light m_bottom_20">
							     @if(!empty(Auth::user()))
							     
								<h5 class="second_font color_dark tt_uppercase fw_light d_inline_m m_bottom_23">Write A Review</h5>
								<form id="product-review-form"> 
									<ul>
									    <input type="hidden" name="product-id" id="product-id" value="{{$product->id}}">
										<li class="m_bottom_9">
											<label for="review" class="second_font required clickable d_inline_b m_bottom_5">Your Review</label><br>
											<textarea class="tr_all w_full fw_light fs_medium color_light" id="review" name="review" rows="5" required></textarea>
											<div class="text-danger validation-err" id="review-err"></div>
										</li> 
										<li class="clearfix">
											<div class="f_left m_top_2">
												<label class="second_font required clickable d_inline_m m_right_5">Rating</label>
												   <input type="radio" name="rating" value="1" id="star1">
                                            <label for="star1">1 Star</label>
                                            
                                            <input type="radio" name="rating" value="2" id="star2">
                                            <label for="star2">2 Stars</label>
                                            
                                            <input type="radio" name="rating" value="3" id="star3">
                                            <label for="star3">3 Stars</label>
                                            
                                            <input type="radio" name="rating" value="4" id="star4">
                                            <label for="star4">4 Stars</label>
                                            
                                            <input type="radio" name="rating" value="5" id="star5">
                                            <label for="star5">5 Stars</label>
                                            <div class="text-danger validation-err" id="rating-err"></div>
											</div>
											<button type="button" class="button_type_2 d_block t_align_c black state_2 tr_all second_font fs_medium tt_uppercase f_right submit-review-btn"><span class="d_inline_b m_left_10 m_right_10">Submit</span></button>
										</li>
									</ul>
								</form>
								@endif
							</div>
						</div>
						  @if(!$relatedProduct->isEmpty())
						<div class="d_table m_bottom_5 w_full">
							<div class="col-lg-6 col-md-6 col-sm-6 col-xs-8 v_align_m d_table_cell f_none">
								<h5 class="second_font color_dark tt_uppercase fw_light d_inline_m m_bottom_4">Related Products</h5>	
							</div>
							<div class="col-lg-6 col-md-6 col-sm-6 col-xs-4 t_align_r d_table_cell f_none">
								<!--carousel navigation-->
								<div class="clearfix d_inline_b">
									<button class="rp_prev black_hover button_type_4 grey state_2 tr_all d_block f_left vc_child m_right_5"><i class="fa fa-angle-left d_inline_m"></i></button>
									<button class="rp_next black_hover button_type_4 grey state_2 tr_all d_block f_left vc_child"><i class="fa fa-angle-right d_inline_m"></i></button>
								</div>
							</div>
						</div>
						<hr class="divider_bg m_bottom_15">
						<div class="row">
							<!--carousel-->
							<div class="owl-carousel m_bottom_20 m_xs_bottom_0" data-nav="rp_" data-owl-carousel-options='{
								"stagePadding" : 15,
								"margin" : 30,
								"responsive" : {
										"0" : {
											"items" : 1
										},
										"321" : {
											"items" : 2
										},
										"768" : {
											"items" : 3
										},
										"992" : {
											"items" : 4
										}
									}
								}'>
                            @foreach($relatedProduct as $relatedProductData)						
								<figure class="relative r_image_container c_image_container qv_container">
									<div class="relative m_bottom_15">
										<div>
										    <a href="{{ route('productsdetails', $relatedProductData->id) }}">
										     <img src="{{env('APP_URL')}}{{$relatedProductData->front_image}}" class="c_image_1 tr_all" alt="image">
                                             <img src="{{env('APP_URL')}}{{$relatedProductData->hover_image}}" class="c_image_2 tr_all" alt="image">
                                             </a>
										</div>
										<!--<a data-popup="#quick_view" data-popup-transition-in="bounceInUp" data-popup-transition-out="bounceOutUp" class="tr_all color_white second_font qv_style_button quick_view tt_uppercase t_align_c d_block clickable d_xs_none"><i class="fa fa-eye d_inline_m m_right_10"></i><span class="fs_medium">Quick View</span></a>-->
									</div>
									<figcaption class="t_align_c">
										<ul>
											<li><a href="{{route('productsdetails',$relatedProductData->id)}}" class="second_font sc_hover">{{$relatedProductData->name}}</a></li>
									
											<li class="m_bottom_16"><b class="fs_large second_font scheme_color">
											    
											    ₹{{$relatedProductData->sizes[0]->sell_price}}</b></li>
											<li>
												<div class="clearfix d_inline_b">
												<!--	<button class="button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative"><i class="fa fa-heart fs_large d_inline_m"></i><span class="tooltip top fs_small color_white hidden animated" data-show="fadeInDown" data-hide="fadeOutUp">Add to Wishlist</span></button>
													<button class="button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative"><i class="fa fa-arrow-right fs_small d_inline_m"></i><i class="fa fa-arrow-left fs_small d_inline_m"></i><span class="tooltip top fs_small color_white hidden animated" data-show="fadeInDown" data-hide="fadeOutUp">Add to Compare</span></button>-->
													<a href="{{route('productsdetails',$relatedProductData->id)}}" data-popup-transition-in="bounceInUp" data-popup-transition-out="bounceOutUp" class="button_type_8 tr_all lbrown state_2 f_left color_dark t_align_c vc_child tooltip_container relative"><i class="fa fa-shopping-cart fs_large d_inline_m"></i><span class="tooltip top fs_small color_white hidden animated" data-show="fadeInDown" data-hide="fadeOutUp">Add to Cart</span></a>
												</div>
											</li>
										</ul>
									</figcaption>
								</figure>
							@endforeach
							</div>
						</div>
						@endif
					</section>
				</div>
			</div>
			
			<script>
    function openLink(select) {
        var url = select.value;
        if (url !== "#") {
            window.open(url, "_blank");
        }
    }
</script>

@endsection