@extends('front.layouts.app')

@section('content')
<style>
    [class*="isotope_container"].three_columns [class*="isotope_item"] {
    width: 33.3333%;
    float: left !important;
}


</style>
	<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container">
					<a href="{{route('homePage')}}" class="sc_hover">Home</a> <span class="color_dark">/</span> <a href="javascript:void(0)" class="sc_hover">Products</a>
				</div>
			</div>
			<!--main content-->
			<div class="page_section_offset">
				<div class="container">
					<div class="row">
						<aside class="col-lg-3 col-md-3 col-sm-3 m_xs_bottom_30 p_top_4">
							<!--filter widget-->
							<section class="m_bottom_38 m_xs_bottom_30 side_filter">
								<h5 class="color_dark tt_uppercase second_font fw_light m_bottom_13">Filter</h5>
								<hr class="divider_bg m_bottom_23">
								<form id="price-range-form" method="GET" action="{{ route('shoplisting',selectedSlug()) }}">
									<div class="relative">
										<fieldset>
											<legend class="second_font m_bottom_10 w_full"><h4>Categories</h4></legend> 
											<ul class="categories_filter">
											    @foreach(GetAllCategory() as $categoryData)
                                                   <!-- <li><a href="{{route('shoplisting',$categoryData->slug)}}">{{$categoryData->name}}</a></li>-->
                                                    <li class="m_bottom_9">
    													<a href="{{route('shoplisting',$categoryData->slug)}}">{{$categoryData->name}}</a>
    												</li>
                                                @endforeach
												
											</ul>
											<span class="close fieldset_c hidden fs_small color_light tr_all color_dark_hover fw_light">x</span>
											<hr class="divider_light m_bottom_10">
										</fieldset>
									</div>
									<div class="relative">
										<fieldset>
											<legend class="second_font m_bottom_15 w_full"><b>Price</b></legend>
											
											<div class="range-slider" style="width: 200px;">
											     <span class="rangeValues"></span>
											     <input value="1000" min="1000" max="50000" step="500" type="range">
											     <input value="50000" min="1000" max="50000" step="500" type="range">
											</div>
											<!--<div class="range_slider relative bg_grey_light_2 m_bottom_10"></div>
											<div class="clearfix m_bottom_10">
												<input type="text" class="f_left range_min half_column fw_light" readonly>
												<input type="text" class="f_right range_max half_column t_align_r fw_light" readonly>
											</div>
											<span class="close fieldset_c hidden fs_small color_light tr_all color_dark_hover fw_light">x</span>-->
											<hr class="divider_light m_bottom_10">
										</fieldset>
									</div>
									<div class="relative">
										<fieldset>
									
											<span class="close fieldset_c hidden fs_small color_light tr_all color_dark_hover fw_light">x</span>
											<hr class="divider_light m_bottom_10">
										</fieldset>
									</div>
									<div class="relative">
										<fieldset>
											<legend class="second_font m_bottom_10 w_full"><b>Color</b></legend>
											<ul class="hr_list m_bottom_12">
											<!--	<li class="m_right_5 m_bottom_3"><button class="color_button bg_light_red tr_all"></button></li>
												<li class="m_right_5 m_bottom_3"><button class="color_button bg_light_blue tr_all"></button></li>
												<li class="m_right_5 m_bottom_3"><button class="color_button bg_light_green tr_all"></button></li>
												<li class="m_right_5 m_bottom_3"><button class="color_button bg_grey tr_all"></button></li>
												<li class="m_right_5 m_bottom_3"><button class="color_button bg_light_yellow tr_all"></button></li>-->
												    @if(!empty(getAllColors()))
                                                        @foreach(getAllColors() as $colorData)
                                                        <li>
                                                            <!--<a href="#" title="Red" class="color-red"></a>-->
                                                             <input type="checkbox" name="colors[]" id="color_{{$colorData->id}}" value="{{ $colorData->id }}" @if($selectedColors->contains($colorData->id)) checked @endif>
                                                              <label for="color_{{$colorData->id}}" class="d_inline_b fw_light p_top_0 p_bottom_0">{{ $colorData->name }}</label>
                                                        </li> 
                                                        @endforeach
                                                    @endif
											</ul>
											<span class="close fieldset_c hidden fs_small color_light tr_all color_dark_hover fw_light">x</span>
											<hr class="divider_light m_bottom_10">
										</fieldset>
									</div>
								 <button type="submit" class="update_details button_type_2 d_block w_full t_align_c grey state_2 tr_all second_font fs_medium tt_uppercase filter_reset" style="margin-bottom:5px;">Search</button>
									<a href="{{ route('shoplisting','all') }}" type="reset" class="button_type_2 d_block w_full t_align_c grey state_2 tr_all second_font fs_medium tt_uppercase filter_reset"><i class="fa fa-refresh d_inline_m m_right_9 fs_"></i>Reset</a>
							
							</section>
						
							<!--compare products widget-->
						
						</aside>
						<main class="col-lg-9 col-md-9 col-sm-9 m_bottom_30 m_xs_bottom_10">
							<h2 class="fw_light second_font color_dark tt_uppercase m_bottom_27">Products</h2>
							<figure class="m_bottom_45 m_xs_bottom_30">
								<!--<img src="https://tossas.in/sandman/public/front/assets/images/categorynew.jpg" alt="" class="m_bottom_15">-->
								<figcaption>
									<!--<p class="fw_light">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse sollicitudin velit sed leo. Ut pharetra augue nec erat volutpat. Duis ac turpis. Donec sit amet eros. Lorem ipsum dolor sit amet.</p>-->
								</figcaption>
							</figure>
					
							<div class="d_table w_full m_bottom_5">
								<div class="col-lg-6 col-md-6 col-sm-6 d_xs_block v_align_m d_table_cell f_none fs_medium color_light fw_light m_xs_bottom_5">
									<div class="d_inline_m m_right_5">Sort by:</div>
									<div class="styled_select relative d_inline_m m_right_2">
										<div class="select_title type_3 fs_medium fw_light color_light relative d_none tr_all">Sort By</div>
										<select onChange="getValue()" name="sort_by">
                                                 <option value='default' @if($sortOrder === 'default') selected @endif>Sort By</option>
                                                <option value="low-to-high" @if($sortOrder === 'low-to-high') selected @endif>Sort by Price: Low to High</option>
                                               
                                                <option value="popularity" @if($sortOrder === 'popularity') selected @endif>Sort by Popularity</option>
                                                <option value="rating" @if($sortOrder === 'rating') selected @endif>Sort by Average Rating</option>
                                                <!--<option value="latest" @if($sortOrder === 'latest') selected @endif>Sort by Latest</option>-->
                                                <option value="high-to-low" @if($sortOrder === 'high-to-low') selected @endif> Sort by Price: High to Low</option>
                                            </select>
									
										<ul class="options_list d_none tr_all hidden bg_grey_light_2"></ul>
									</div>
									<button class="button_type_4 grey state_2 tr_all second_font tt_uppercase vc_child black_hover">
                                        <i class="fa fa-search d_inline_m m_right_5"></i>
                                    </button>

									<!--<button class="button_type_4 grey state_2 tr_all second_font tt_uppercase vc_child black_hover"><i class="fa fa-sort-amount-asc d_inline_m m_top_0"></i></i></button>-->
								</div>
						
							</div>
								</form>
							<hr class="divider_light m_bottom_5">
						
							<div id="can_change_layout" class="category_isotope_container three_columns wrapper m_bottom_10 m_xs_bottom_0">
								<!--isotope item-->
								@if(!empty($products))
                    @foreach($products as $productData)
								<div class="category_isotope_item">
									<figure class="product_item type_2 c_image_container relative frame_container t_sm_align_c r_image_container qv_container">
										<!--image & buttons & label-->
										<div class="relative">
											<div class="d_block">
											    <a href="{{route('productsdetails',$productData->id)}}">
                                                    <img src="{{env('APP_URL')}}{{$productData->front_image}}" class="c_image_1 tr_all" alt="image">
                                                    @if(!empty($productData->hover_image))
                                                         <img src="{{env('APP_URL')}}{{$productData->hover_image}}" class="c_image_2 tr_all" alt="image">
                                                    @else
                                                        <img src="{{env('APP_URL')}}{{$productData->front_image}}" class="c_image_2 tr_all" alt="image">
                                                    @endif
                                                    
                                                </a>

												<!--<img src="{{env('APP_URL')}}public/front/assets/images/263x263-5.jpg" alt="" class="c_image_1 tr_all">-->
												<!--<img src="{{env('APP_URL')}}public/front/assets/images/263x263-5.jpg" alt="" class="c_image_2 tr_all">-->
											</div>
											<!--<div class="product_label fs_ex_small circle color_white bg_lbrown t_align_c vc_child tt_uppercase"><i class="d_inline_m">Sale!</i></div>-->
											<a href="{{route('productsdetails',$productData->id)}}" class="tr_all color_white second_font qv_style_button quick_view tt_uppercase t_align_c d_block clickable d_xs_none"><i class="fa fa-eye d_inline_m m_right_10"></i><span class="fs_medium">Quick View</span></a>
										</div>
										<figcaption class="bg_white relative p_bottom_0">
											<div class="row">
												<div class="col-lg-12 col-md-12 m_bottom_5 t_align_l">
													<a class="second_font sc_hover d_xs_block" href="{{route('productsdetails',$productData->id)}}">
													  
													    {{ strlen($productData->name) > 15 ? substr($productData->name, 0, 30) . '...' : $productData->name }}
													    </a>
													<div class="relative">
														<a href="#" class="fw_light color_light sc_hover category_link tr_all">Sand Clay</a><br class="d_none">
														<ul class="rating_list hr_list d_sm_inline_b tr_all">
                                                            <div class="rating-stars">
                                                                @for($i = 1; $i <= 5; $i++)
                                                                    @if($i <= $productData->averageRating)
                                                                        <span class="filled-star" style="color: #d6a916;">&#9733;</span>
                                                                    @else
                                                                        <span class="empty-star">&#9733;</span>
                                                                    @endif
                                                                @endfor
                                                            </div>
                                                        </ul>
														<span class="color_light reviews d_none">
															<a href="#" class="sc_hover fs_medium fw_light">3 Review(s)</a> | <a href="#" class="color_dark sc_hover fs_medium fw_light">Add Your Review</a>
														</span>
													</div>
													<hr class="d_none divider_light m_bottom_15">
													<p class="fw_light d_none m_bottom_14 color_grey">Mauris fermentum dictum magna. Sed laoreet aliquam leo. Ut tellus dolor, dapibus eget, elementum vel, cursus eleifend, elit. Aenean auctor wisi et urna. Aliquam erat volutpat. Duis ac turpis. Integer rutrum ante eu lacus.</p>
													<hr class="d_none divider_light m_bottom_15">
												</div>
												<div class="col-lg-12 col-md-12 color_light fs_large second_font t_align_r t_sm_align_r m_bottom_9 pric">
												    
										<ul class="price_value"> 
										 <li><span class="regularprice">@if($productData->sizes[0]->price > $productData->sizes[0]->sell_price)
                                            ₹{{$productData->sizes[0]->price}}
                                        @endif</span></li>
                                        <li>
                                            	<b class="scheme_color d_block">₹{{$productData->sizes[0]->sell_price}}</b>
                                        </li>
												</ul>
												</div>
											</div>
											<a href="{{route('productsdetails',$productData->id)}}" data-popup-transition-in="bounceInUp" data-popup-transition-out="bounceOutUp" class="button_type_2 m_bottom_9 d_block w_full t_align_c lbrown state_2 tr_all second_font fs_medium tt_uppercase"><i class="fa fa-shopping-cart d_inline_m m_right_9"></i>Add To Cart</a>
												<button class="button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative d_none"><i class="fa fa-heart fs_large d_inline_m"></i><span class="tooltip top fs_small color_white hidden animated" data-show="fadeInDown" data-hide="fadeOutUp">Add to Wishlist</span></button>
											<!--<button class="button_type_8 grey state_2 tr_delay color_dark t_align_c vc_child f_left m_right_3 tooltip_container relative d_none"><i class="fa fa-arrow-right fs_small d_inline_m"></i><i class="fa fa-arrow-left fs_small d_inline_m"></i><span class="tooltip top fs_small color_white hidden animated" data-show="fadeInDown" data-hide="fadeOutUp">Add to Compare</span></button>-->
										<div class="clearfix t_sm_align_c t_xs_align_l" style="text-align:center;">
											
						<!--						<a href="#" class="second_font f_sm_none d_sm_inline_b f_xs_right fs_medium sc_hover f_right">Add to Compare</a>-->
											</div>
										</figcaption>
									</figure>
								</div>
								@endforeach
								@endif
						
							</div>
						
								</div>
							</div>
						</main>
					</div>
				</div>
			</div>


  <script>
    function getValue(){
       $('#price-range-form').submit();
    }
    </script>
@endsection