@extends('front.layouts.app')
@section('title','Orders Detail')
@section('content') 
       

<style>
    .text-right {
    text-align: right;
}
.ship_add p {
    margin-bottom: 0px;
    font-size: 14px;
    line-height: 1.5em;
}
</style>



<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container">
					<a href="https://tossas.in/sandman" class="sc_hover">Home</a> / <span class="color_light">Order Detail</span>
				</div>
			</div>

        <!-- shop-page-section -->
        <section class="shop-page-section sidebar-page-container shop-page-2 introduction dashboard">
            <div class="container">
                <div class="row clearfix">
                 @include('front.customer.sidebar')
                    <div class="col-lg-9 col-md-12 col-sm-12 content-side">
                        
        <div class="container mt-5 mb-5">
        <div class="row d-flex justify-content-center">
            <div class="col-md-8">
                <div class="card">
                        <div class="text-center logo_inner p-2 px-5">
                            <h6 class="user_info orderpaged" style="text-transform:uppercase; margin-top:25px;">Order Detail</h6>
                        </div>
                        <div class="invoice p-3">
                            <div class="payment-thanku border-top mt-3 mb-3 border-bottom">
                                <table class="table table-borderless table-width" style="margin-bottom: 0;">
                                    <tbody>
                                        <tr>
                                            <td style="text-align: left;">
                                                <div class="py-2">

                                                    <span class="d-block text-muted" style="color: black !important;
    font-weight: bold;
    font-size: 16px !important;
    margin-bottom: 5px;">Order Date: </span>
                                                <span>{{ $orders->created_at->format('d M Y') }}</span>
                                                    
                                                </div>
                                            </td>

                                            <td style="text-align: center;">
                                                <div class="py-2">

                                                    <span class="d-block text-muted" style="color: black !important;
    font-weight: bold;
    font-size: 16px !important;
    margin-bottom: 5px;">Order No: </span>
                                                <span>{{ $orders->order_number }}</span>
                                                    
                                                </div>
                                            </td>

                                            <td style="text-align: right;">
                                                <div class="py-2">

                                                    <span class="d-block text-muted" style="color: black !important;
    font-weight: bold;
    font-size: 16px !important;
    margin-bottom: 5px;">Payment: </span>
                                                <span>
                                                    {{$orders->payment_mode}}
                                                    <!--<img src="https://img.icons8.com/color/48/000000/mastercard.png" width="20" />-->
                                                    </span>
                                                    
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <div class="shipping_address">
                                    <table class="table-responsive" style="width:100%;">
                                         <tr> <td style="padding: 20px 10px;">
                                                <div class="py-2">
 @if(!empty($customer_address))
                                                    <span class="d-block text-muted" style="color: black !important;
    font-weight: bold;
    font-size: 16px !important;
    margin-bottom: 5px;">Shiping Address</span>
   
                                                <!--<span>{{ $customer_address->address }}, {{ $customer_address->city }},</span>
                                                <span> {{ $customer_address->state }} , {{ $customer_address->country }} - {{ $customer_address->pin_code }}</span>-->
                                                <div class="ship_add">
                                                    <p>{{ $customer_address->name }}</p>
                                                <p>{{ $customer_address->address }}, {{ $customer_address->city_id }}</p>
                                                <p>{{ $customer_address->city_id }}, {{ $customer_address->state_id }}-{{ $customer_address->pin_code }}, India</p>
                                                <p>+91 {{ $customer_address->mobile }}</p>
                                                <p>{{ $customer_address->email}}</p>
                                                </div>
                                                @endif
                                                    
                                                </div>
                                            </td></tr>
                                    </table>
                                </div>




                                
                            </div>




                                <div class="product border-bottom shop_table">

                                    <table class="table table-borderless table-width">

                                    <tbody>
                                        @if($orders->order_details)
                                        @foreach($orders->order_details as $orderDetailData)
                                        <tr>
                                            <td width="25%">
                                                <?php 
                                                    //dd($orderDetailData->$orderDetailData->product->product_colors);
                                                    ?>
                                             <img src="{{env('APP_URL')}}{{$orderDetailData->product->front_image}}" alt="" width="80px">
                                            

                                        </td>
                                    
                                        <td width="50%">
                                            <span class="font-weight-bold">{{$orderDetailData->product->name}}</span>
                                            <div class="product-qty">
                                                <span class="d-block">Quantity:{{$orderDetailData->quantity}}</span>
                                                @if(!empty($orderDetailData->product_size_id))
                                                <?php $getSize = DB::table('product_sizes')->where('id',$orderDetailData->product_size_id)->first();
                                                    $getSizeName = DB::table('sizes')->where('id',$getSize->size_id)->first();
                                                ?><br>
                                                <span>Size: {{$getSizeName->name}}
                                                
                                                </span>@endif
                                                
                                            </div>
                                        </td>
                                        <td width="25%">
                                            <div class="text-right">
                                                <span class="font-weight-bold">₹{{$orderDetailData->total_price}}</span>
                                                 <!--<span class="d-block">Product Price:{{$orderDetailData->pro_actual_price}}</span>-->
                                                 <!--<span>Discount:{{$orderDetailData->discount_percentage }}</span>-->
                                            </div>
                                        </td>
                                        </tr>
                                        @endforeach
                                    @endif

                                    </tbody> 
                                        
                                    </table>
                                    


                                </div>



                                <div class="row d-flex justify-content-end">

                                    <div class="col-md-12">

                                        <table class="table table-borderless bottom_wid">

                                            <tbody class="totals">

                                                <tr>
                                                    <td>
                                                        <div class="text-left">

                                                            <span class="text-muted">Subtotal</span>
                                                            
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="text-right">
                                                            <span>₹{{$orders->order_amount}}</span>
                                                        </div>
                                                    </td>
                                                </tr>


                                                <!-- <tr>-->
                                                <!--    <td>-->
                                                <!--        <div class="text-left">-->

                                                <!--            <span class="text-muted">Discount</span>-->
                                                            
                                                <!--        </div>-->
                                                <!--    </td>-->
                                                <!--    <td>-->
                                                <!--        <div class="text-right">-->
                                                <!--            <span class="text-success">₹{{$orders->discount_amount}}</span>-->
                                                <!--        </div>-->
                                                <!--    </td>-->
                                                <!--</tr>-->

                                                <tr>
                                                    <td>
                                                        <div class="text-left">

                                                            <span class="text-muted">Coupon Discount</span>
                                                            
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="text-right">
                                                            <span class="text-success">
                                                            @if(!empty($orders->coupon_discount) || $orders->coupon_discount == 0)
                                                                ₹{{$orders->discount_amount}}
                                                            @else
                                                                ₹0
                                                            @endif
                                                            </span>
                                                        </div>
                                                    </td>
                                                   
                                                </tr>
                                                <tr>
                                                     <td>
                                                        <div class="text-left">

                                                            <span class="text-muted">Shipping Amount</span>
                                                            
                                                        </div>
                                                    </td>
                                                       <td>
                                                        <div class="text-right">
                                                            <span class="text-success">@if(!empty($orders->shipping_amount))
                                                                ₹{{$orders->shipping_amount}}
                                                            @else
                                                                ₹0
                                                            @endif
                                                            </span>
                                                        </div>
                                                    </td>
                                                </tr>

                                                 <tr class="border-top border-bottom">
                                                    <td>
                                                        <div class="text-left">

                                                            <span class="font-weight-bold">Total</span>
                                                            
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="text-right">
                                                            <span class="font-weight-bold">₹{{$orders->order_amount_after_discount}}</span>
                                                        </div>
                                                    </td>
                                                </tr>
                                                
                                            </tbody>
                                            
                                        </table>
                                        
                                    </div>
                                    


                                </div>

                        </div>
<div class="footer_text text-center">
    @if(!empty($orders->invoice_link))
    <a href="{{$orders->invoice_link}}" target="_blank">Download Invoice</a>
@endif

</div>

                



            
        </div>
            </div>
            <div class="col-lg-2"></div>
            <div class="col-lg-2"></div>
        </div>
        
    </div>
                    </div>
                </div>
            </div>
        </section>
        @endsection