@extends('front.layouts.app')
@section('title','Account Setting')
@section('content') 
  <style type="text/css">input {
    border: 1px solid #c4c4c4;
    padding: 5px 5px;
    border-radius: 5px;
    width: 100%;
}.form-inner {
    padding: 50px 20px;
    box-shadow: 1px 1px 10px 1px #cac5c5;
}
.extraspace {
    height: 100px;
}.page-title h1 {
    font-size: 36px;
    color: white;
}ul.bread-crumb.clearfix li {
    display: inline-block;
    padding: 0px 6px;
    color: #ff8b8b;
}
.error-message {
        color: red;
        width: 100%; /* Ensure the error message takes up full width */
        display: block; /* Ensure each error message appears on a new line */
    }
    .alert-message {
        width: 93%;
        position: absolute;
        top: 40px;
        background-color: #d7f8e2; /* Reducing red color for alert */
        color: #721c24; /* Darkening text color for alert */
        padding: 15px;
        box-sizing: border-box;
        border-radius: 5px;
    }
</style>


<section> 
<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container">
					<a href="{{route('homePage')}}" class="sc_hover">Home</a> / <span class="color_light">My Account</span>
				</div>
			</div>
                
            	<div class="introduction dashboard">
				<div class="container">
                    <div class="row">
                    @include('front.customer.sidebar')
                     <div class="col col-lg-9 order_data">
                            <div class="account_content_area">
                            <div class="light-bg default-box-shadow">
<div class="form-inner">
    <div class="card-body p-4">
                                    @if(Session::has('success'))
                                        <div class="alert-message" id="success-alert">
                                            {{ Session::get('success') }}
                                        </div>
                                    @endif
                                    @if(Session::has('error'))
                                        <div class="alert-message" id="error-alert">
                                            {{ Session::get('error') }}
                                        </div>
                                    @endif
                                </div>
                        <form method="post" action="{{route('updateMyAccount')}}" id="contact-form" class="default-form" novalidate="novalidate"  enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                     <label for="acc-name">Name <span class="">*</span></label>
                                    <input type="text" name="name"  id="name" value="{{Auth::user()->name}}" class="form-control @error('name') is-invalid @enderror" placeholder="Your name">
                                @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                </div>
                              
                               <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Email
                                        <span class="">*</span></label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" name="email" placeholder="Your email" value="{{Auth::user()->email}}">

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                                </div>
                                
                                  <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Mobile
                                        <span class="">*</span></label>
                                <input type="number"  name="phone_number" class="form-control  @error('phone_number') is-invalid @enderror " value="{{Auth::user()->phone_number}}" placeholder="Your mobile number">

                                 @error('phone_number')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                                </div>


                                  <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Your Image
                                        <span class="">*</span></label>
                                    <input type="file" name="image" id="image">

                    @if(!empty($user->image))
                        <img class="profile-user-img img-fluid img-circle"  src="{{env('APP_URL')}}{{$user->image}}" style="margin-top:5px;padding:5px;border: 1px solid !important width:80px; height: 80px;"; >
                   
                    @endif
                                </div>
                                
                                <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn left">
                                    <button type="submit" class="theme-btn-two update_details updatebt">Update Now!<i class="flaticon-right-1"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>

                                <!--<div class="continue-shopping">-->
                                <!--     <a class="pink-btn btn" href="{{route('userDashboard')}}"> Back To Dashboard </a>                           -->
                                <!--</div>-->
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>    
        <script>
    
    setTimeout(function() {
        document.getElementById('success-alert').style.display = 'none';
        document.getElementById('error-alert').style.display = 'none';
    }, 2000);
</script>
            </section>
        @endsection