@extends('front.layouts.app')
@section('title','Update Address')
@section('content') 
  <style type="text/css">input {
    border: 1px solid #c4c4c4;
    padding: 5px 5px;
    border-radius: 5px;
    width: 100%;
}.form-inner {
    padding: 50px 20px;
    box-shadow: 1px 1px 10px 1px #cac5c5;
    border-top: 10px solid #ff4135;
}</style>

   
<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container color_dark">
					<a href="{{ route('homePage')}}" class="sc_hover">Home</a> / <span class="color_light">Edit Address</span>
				</div>
			</div> 

        <!-- shop-page-section -->
        <!-- shop-page-section -->
       	<div class="introduction">
				<div class="container">
                    <div class="row">
                         @include('front.customer.sidebar')

                        <div class="col col-lg-9">
                            <div class="account_content_area">
                                <h3>Update Address</h3>
                            <div class="light-bg default-box-shadow">
                  <div class="form-inner">
                       
                          <form method="POST" action="{{ route('updateMyAddressBook', ['id' => $customer_address->id]) }}" class="default-form" novalidate="novalidate" enctype="multipart/form-data">
    @csrf
                            <div class="row">

                               <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Name <span class="">*</span></label>
                                    <input type="text" name="name" id="name" value="{{$customer_address->name}}" class="form-control @error('name') is-invalid @enderror" placeholder="Your name">
                                    <div class="text-danger validation-err" id="name-err"></div>
                                </div>
                              
                                
                                  <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Mobile
                                        <span class="">*</span></label>
                                <input type="number"  name="mobile" id="mobile" class="form-control  @error('mobile') is-invalid @enderror " placeholder="Your mobile number" value="{{$customer_address->mobile}}">
                                  <div class="text-danger validation-err" id="mobile-err"></div>
                              
                                </div>


                                  

                                  <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Town / City
                                        <span class="">*</span></label>
                                 <input type="text"  name="town_city" id="town_city" class="form-control  @error('town_city') is-invalid @enderror " placeholder="Your City Name" value="{{$customer_address->city_id}}">
                  				  <div class="text-danger validation-err" id="town_city-err"></div>
                                </div>


                             <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Pin / Zip Code 
                                        <span class="">*</span></label>
                                 <input type="text"  name="pin_code" class="form-control  @error('pin_code') is-invalid @enderror " id="pin_code" placeholder="Your Zip / Pin Code" value="{{$customer_address->pin_code}}">
                  				 <div class="text-danger validation-err" id="pin_code-err"></div>
                                </div>

                                   <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">State 
                                        <span class="">*</span></label>
                                 <input type="text"  name="state" id="state" class="form-control  @error('state') is-invalid @enderror " placeholder="Your State Name" value="{{$customer_address->state_id}}">
                  				  <div class="text-danger validation-err" id="state-err"></div>
                                </div>

                                 <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Country
                                        <span class="">*</span></label>
                                 <input type="text" id="country" name="country" class="form-control  @error('country') is-invalid @enderror " placeholder="Your Country Name " value="{{$customer_address->country_id}}">
                  				  <div class="text-danger validation-err" id="country-err"></div>
                                </div>

                                    
                                
                                 <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Address
                                        <span class="">*</span></label>
                                 <input type="text"  name="address" id="address" class="form-control  @error('address') is-invalid @enderror " placeholder="Your Address" value="{{$customer_address->address}}">
                  				  <div class="text-danger validation-err" id="address-err"></div>
                                </div>
                                
                                <div class="col-lg-6 col-md-12 col-sm-12 form-group frmlable">
                                    <label for="acc-name">Address Type <span class="">*</span></label>
                                    <div class="row add_check">
                                        <div class="col-lg-6">
                                            <div class="custom-controls-stacked">
                                                <input type="radio" id="home" name="address_type" value="home" {{ $customer_address->address_type == 'home' ? 'checked' : '' }}>
                                                <label for="home">Home</label>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="custom-controls-stacked">
                                                <input type="radio" id="office" name="address_type" value="office" {{ $customer_address->address_type == 'office' ? 'checked' : '' }}>
                                                <label for="office">Office</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn left">
                                    <!--<button type="button" id="update-address-btn" class="theme-btn-two" customer_address_id="{{ $customer_address->id }}">Update Now!<i class="flaticon-right-1"></i></button>-->
                                <button type="submit" class="theme-btn-two" style="padding: 10px 20px; background-color: #d6a916; color: white; border: none; border-radius: 5px; cursor: pointer;">Update Now!<i class="flaticon-right-1"></i></button>

                                </div>
                            </div>
                        </form>
                    </div>

                           
                            </div>
                        </div>


                        </div>
                    </div>
                </div>
            </div>
        <!-- shop-page-section end -->
        @endsection