@extends('front.layouts.app')
@section('title','Add Address')
@section('content') 
  <style type="text/css">input {
    border: 1px solid #c4c4c4;
    padding: 5px 5px;
    border-radius: 5px;
    width: 100%;
}.form-inner {
    padding: 50px 20px;
    box-shadow: 1px 1px 10px 1px #cac5c5;
}
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
</style>

        <!-- page-title end -->

<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container color_dark">
					<a href="{{ route('homePage')}}" class="sc_hover">Home</a> / <span class="color_light">Add Address</span>
				</div>
			</div>
<section> 

                	<div class="introduction dashboard">
				<div class="container">
                    <div class="row">
                         @include('front.customer.sidebar')

                        <div class="col col-lg-9">
                            <div class="account_content_area add_address">
                                <h3>Add Address</h3>
                            <div class="light-bg default-box-shadow">
                                <div class="form-inner">
                                    @if(Session::has('success'))
                                    <div class="alert alert-success" style="color: green;">
                                        {{ Session::get('success') }}
                                    </div>
                                @endif
                                @if(Session::has('error'))
                                    <div class="alert alert-danger" style="color: red;">
                                        {{ Session::get('error') }}
                                    </div>
                                @endif

                        <!--<form method="#" action="#" id="address-form" class="default-form" novalidate="novalidate"  enctype="multipart/form-data">-->
                         <form action="{{ route('SaveNewCustomerAddress') }}" method="post" class="default-form" novalidate="novalidate" enctype="multipart/form-data">
                        @csrf
                          
                            <div class="row">

                                <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                     <label for="acc-name">Name <span class="">*</span></label>
                                    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" placeholder="Your name">
            						<!--<div class="text-danger validation-err" id="name-err"></div>-->
            						 @error('name')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                </div>
                              
                                
                                 <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Mobile <span class="">*</span></label>
                                    <input type="text" name="mobile" id="mobile" class="form-control @error('mobile') is-invalid @enderror" placeholder="Your mobile number" maxlength="10">
                                    @error('mobile')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                </div>



                                  

                                  <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Town / City
                                        <span class="">*</span></label>
                                 <input type="text"  name="town_city" id="town_city" class="form-control  @error('town_city') is-invalid @enderror " placeholder="Your City Name" required>
                  				  <!--<div class="text-danger validation-err" id="town_city-err"></div>-->
                  				   @error('town_city')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                     <label for="acc-name">Pin / Zip Code 
                                        <span class="">*</span></label>
                                 <input type="number"  name="pin_code" class="form-control  @error('pin_code') is-invalid @enderror " id="pin_code" placeholder="Your Zip / Pin Code" required>
                  				 <!--<div class="text-danger validation-err" id="pin_code-err"></div>-->
                  				  @error('pin_code')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                </div>

                                   <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">State 
                                        <span class="">*</span></label>
                                 <input type="text"  name="state" id="state" class="form-control  @error('state') is-invalid @enderror " placeholder="Your State Name" required>
                  				  <!--<div class="text-danger validation-err" id="state-err"></div>-->
                  				   @error('state')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                </div>

                                 <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Country
                                        <span class="">*</span></label>
                                 <input type="text" id="country" name="country" class="form-control  @error('country') is-invalid @enderror " placeholder="Your Country Name " required>
                  				  <!--<div class="text-danger validation-err" id="country-err"></div>-->
                  				  @error('country')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                                    <label for="acc-name">Address
                                        <span class="">*</span></label>
                                 <input type="text"  name="address" id="address" class="form-control  @error('address') is-invalid @enderror " placeholder="Your Address" required>
                  				  <!--<div class="text-danger validation-err" id="address-err"></div>-->
                                   @error('address')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                 <div class="col-lg-6 col-md-12 col-sm-12 form-group frmlable ">

                                 	  <label for="acc-name" >Address Type 
                                        <span class="">*</span></label>
                                        <div class="row add_check">
                                       <div class="col-lg-6">
                                       <div class="custom-controls-stacked">
                                           <input type="radio" id="home" name="fav_language" value="home"><label for="home">Home</label>
                                        <label class="custom-control material-checkbox">
                                           <input type="radio" id="home" name="address_type" class="material-control-input" value="home" checked>
                                            <span class="material-control-indicator"></span>
                                            <span class="description">Home</span>
                                        </label>
                                        
                                    </div>
                                        	</div>

                                        <div class="col-lg-6">
                                         <div class="custom-controls-stacked">
                                             <input type="radio" id="office" name="fav_language" value="office"><label for="office">Office</label>
                                        <label class="custom-control material-checkbox">
                                            <input type="radio" id="office" class="material-control-input" name="address_type" value="office">
                                            <span class="material-control-indicator"></span>
                                            <span class="description">Office</span>
                                        </label>
                                    </div>
                                        	</div> 	
                                        
                                        </div>
                                 	@error('address_type')
                                        <div class="text-danger validation-err">{{ $message }}</div>
                                    @enderror
                                 
                                </div>


                                <!--<div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn left">-->
                                <!--    <button type="button" id="add-address-btn" class="theme-btn-two update_details updatebt">Add Now!<i class="flaticon-right-1"></i></button>-->
                                <!--</div>-->
                                <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn left">
                            <button type="submit" class="theme-btn-two update_details updatebt">Add Now!<i class="flaticon-right-1"></i></button>
                        </div>
                            </div>
                        </form>
                    </div>

                            </div>
                        </div>


                        </div>
                    </div>
                </div>
            </div>
                </section>
    
        @endsection