@extends('admin.layouts.app')
@section('title','All Categories')
@section('content')
<style>
    .three-dots {
        display: inline-block;
        transform: rotate(90deg);
        cursor: pointer;
    }
    element.style {
    position: absolute;
    inset: 0px auto auto 0px;
    margin: 0px;
    transform: translate(-49px, 25px);
}
  .rounded-input {
    border-radius: 20px;
    padding: 8px 12px;
    border: 1px solid #ced4da;
    background-color:#f0f0f0;
}

.filter-btn {
    background-color: #007bff;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 20px;
    cursor: pointer;
}

.reset-btn {
    background-color: #dc3545;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 20px;
    cursor: pointer;
    margin-left: 10px;
}

/* Responsive styles */
@media screen and (max-width: 768px) {
    .rounded-input,
    .filter-btn,
    .reset-btn {
        margin-top: 10px;
    }
}
</style>

  <div class="main-content">
                <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
              <div class="card-body pt-30">
                  <div class="btn-group">
                                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Export
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="#" id="exportToExcel"><i class="fas fa-file-excel"></i> CSV</a>
                                    <!--<a class="dropdown-item" href="#" id="exportToSVG"><i class="fas fa-file-code"></i> SVG</a>-->
                                    <!--<a class="dropdown-item" href="#" id="exportToPNG"><i class="fas fa-file-image"></i> PNG</a>-->
                                    <a class="dropdown-item" href="#" id="copyTable"><i class="fas fa-copy"></i> Copy</a>
                                    <a class="dropdown-item" href="#" id="printTable"><i class="fas fa-print"></i> Print</a>
                                </div>
                            </div>
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <h4 class="font-20"> User List</h4>
                                    </td>
                                    {{--<td><a href="{{ route('user.add') }}" class="btn long">Add new User</a></td>--}}
                                
                                    <td class="text-right">
                                        <form action="#" class="search-form">
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="searchInput"
                                                    placeholder="Search Here">
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                   <div class="card-body pt-30">
                    <div class="row">
                        <div class="col-md-12">
                            <form id="filterForm" method="GET" class="filter-form">
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="startDate"><b>Start Date:</b></label>
                                        <input type="date" id="startDate" name="startDate" class="form-data rounded-input" value="{{ request('startDate') }}">
                                    </div>
                                    <div class="col-md-3">
                                        <label for="endDate"><b>End Date:</b></label>
                                        <input type="date" id="endDate" name="endDate" class="form-data rounded-input" value="{{ request('endDate') }}" max="{{ date('Y-m-d') }}">
                                    </div>
                                    <div class="col-md-3">
                                        <div class="d-flex align-items-center">
                                            <label for="userStatus"><b>Status:</b></label>
                                            <select id="userStatus" name="userStatus" class="form-data rounded-input ml-2">
                                                <option value="">Select Status</option>
                                                <option value="1" {{ request('userStatus') == '1' ? 'selected' : '' }}>Activate</option>
                                                <option value="0" {{ request('userStatus') == '0' ? 'selected' : '' }}>Deactivate</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <button type="submit" class="filter-btn">Search</button>
                                        <button type="button" class="reset-btn" onclick="window.location.href='{{ route('admin.list.user') }}'">Reset</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div id="result"></div>
                </div>

                              
              <!-- /.card-header -->
              <div class="table-responsive">
                <table id="userTable" class="text-nowrap bg-white  table-bordered" >
                  <thead class="bg_dark">
                  <tr> 
                  <th>S/No.</th>
                   <th>Register Date</th>
                    <th>Name</th>
                     <th>Email</th>
                      <th>Phone Number</th>
                    <th>Status </th>
                    <th>Action</th>
                  
                  </tr>
                  </thead>
                  <tbody>
                    @if(!empty($result))
                    @foreach($result as $data)
                  <tr>
                   <td>{{$loop->iteration}}</td>
                   
                   <td>{{ \Carbon\Carbon::parse($data->created_at)->format('d M Y') }}</td>
                    <td>{{$data->name}}</td>
                    <td>{{$data->email}}</td>
                    <td>{{$data->phone_number}}</td>
                    <td>
                    <form action="{{ route('admin.user.status', ['id' => $data->id]) }}" method="post">
                        @csrf
                        @method('put')

                        @if($data->status == 1)
                            <button type="submit" class="btn btn-sm" title="Click To Deactivate" style="background-color: green; color: white;">Activate</button>
                            <input type="hidden" name="action" value="deactivate">
                        @else
                            <button type="submit" class="btn btn-sm" title="Click To Deactivate" style="background-color: red; color: white;">Deactivate</button>
                            <input type="hidden" name="action" value="activate">
                        @endif
                    </form>
                </td>
                <td>
                         <div class="dropdown">
                                        <span class="three-dots" data-bs-toggle="dropdown" aria-expanded="false" data-userid="{{ $data->id }}">
                                            <h3>...</h3>
                                        </span>
                                        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton1">
                                            <li>
                                                <a class="dropdown-item" href="{{ route('admin.user.details', ['id' => $data->id]) }}">View  Details</a>
                                            </li>
                                            <li>
                                                <a class "dropdown-item" href="{{ route('user.edit', ['id' => $data->id]) }}">Edit</a>
                                            </li>
                                            <!-- <li>
                                                <a class "dropdown-item" href="#">Active</a>
                                            </li> -->
                                        </ul>
                                    </div>
                                </td>
                  </tr>

    
                  @endforeach
                  @endif
              
               
                  </tbody>
                  
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.0/xlsx.full.min.js"></script>
          <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js"></script>
          <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script>
    $(document).ready(function() {
        $(".three-dots").click(function() {
            var userId = $(this).data('userid');

            $("#user-id").val(userId);
        });
    });
    
     $(document).ready(function () {
        $("#searchInput").on("keyup", function () {
            var value = $(this).val().toLowerCase();
            $("#userTable tbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        });
    });
</script>
<script>
    document.getElementById('exportToExcel').addEventListener('click', function() {
        exportTable('xlsx', 'users.xlsx');
    });

    document.getElementById('exportToSVG').addEventListener('click', function() {
        exportToSVG('users.svg');
    });

    document.getElementById('exportToPNG').addEventListener('click', function() {
        exportToPNG('users.png');
    });

    function exportTable(format, fileName) {
        var table = document.getElementById('userTable');
        var workbook = XLSX.utils.table_to_book(table, {sheet: "Sheet 1"});
        var excelBuffer = XLSX.write(workbook, {bookType: format, type: 'array'});
        var blob = new Blob([excelBuffer], {type: 'application/octet-stream'});
        var downloadLink = document.createElement('a');
        downloadLink.href = window.URL.createObjectURL(blob);
        downloadLink.download = fileName;
        downloadLink.click();
    }

    function exportToSVG(fileName) {
        var table = document.getElementById('userTable');
        html2canvas(table).then(function(canvas) {
            var svgData = canvas.toDataURL("image/svg+xml");
            var downloadLink = document.createElement('a');
            downloadLink.href = svgData;
            downloadLink.download = fileName;
            downloadLink.click();
        });
    }

    function exportToPNG(fileName) {
        var table = document.getElementById('userTable');
        html2canvas(table).then(function(canvas) {
            var pngData = canvas.toDataURL("image/png");
            var downloadLink = document.createElement('a');
            downloadLink.href = pngData;
            downloadLink.download = fileName;
            downloadLink.click();
        });
    }

    document.getElementById('copyTable').addEventListener('click', function() {
        var table = document.getElementById('userTable');
        var range = document.createRange();
        range.selectNode(table);
        window.getSelection().removeAllRanges();
        window.getSelection().addRange(range);
        document.execCommand('copy');
        window.getSelection().removeAllRanges();
        alert('Table copied to clipboard!');
    });

    document.getElementById('printTable').addEventListener('click', function() {
        window.print();
    });
</script>


@endsection
