@extends('admin.layouts.app')
@section('title','All Categories')
@section('content')

  <div class="main-content">
                <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card mb-30">
                   <div class="card-body pt-30">
                                   
                                     <table>
                                       <tbody><tr><td> <h4 class="font-20 ">Sub Category List</h4></td><td style="text-align:right;"><a href="{{route('subcategory.add')}}" class="btn long">Add new Sub Category</a></td></tr>
                                   </tbody></table>
                                </div>
                              
              <!-- /.card-header -->
              <div class="table-responsive">
                <table class="text-nowrap bg-white dh-table table-bordered">
                  <thead class="bg_dark">
                  <tr>
                    <th>Category Name</th>
                    <th>Name</th>
                    <th>Status </th>
                    <th>Action </th>
                  
                  </tr>
                  </thead>
                  <tbody>
                    @if(count($categories) > 0)
                    @foreach($categories as $cat)
                  <tr>
                      <td>
                         {{$cat->category_name}}
                      </td>
                    <td>{{$cat->name}}</td>
                     <td>
                        @if($cat->status == 1)
                     <button type="button" class="btn btn-success  btn-sm"  title="Click To Deactivate Category"  data-value="block">
                      Active
                     </button>
                     @else
                        <button type="button"class="btn btn-danger  btn-sm" title="Click To Activate Category" data-value="active">
                          InActive
                     </button>
                     @endif

                     </td>
                     <td>


                         {!! Html::decode(link_to_route('subcategory.edit','<i class="icofont-edit"></i>',[$cat->id],['class'=>'btn btn-primary','title'=>'Edit'])) !!}  
                     </td>
                    
              
                    
                  </tr>

    
                  @endforeach
                  @endif
              
               
                  </tbody>
                  
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>


@endsection
