@extends('admin.layouts.app')
@section('title','Edit Category')

@section('content')

   <div class="main-content d-flex justify-content-center align-items-center">
             
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <!-- Base Control -->
                        <div class="form-element base-control mb-30">
                            <h4 class="font-20 mb-4">Edit Slider</h4>

                            <!-- Form -->
                            <form method="post" action="{{route('slider.update',$data->id)}}" enctype="multipart/form-data">
@csrf
                                <!-- Form Group -->
                                   <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Banner For</label>
                                     <select class="form-control banner_for @error('banner_for') is-invalid @enderror select2" style="width: 100%;" id="banner_for" name="banner_for">
                                    <option value="mobile" {{('mobile' == $data->banner_for) ? 'selected': ''}}>Mobile</option>
                                    <option value="desktop" {{('desktop' == $data->banner_for) ? 'selected': ''}}>Desktop</option>
                                    </select>
                                     @error('banner_for')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Banner Name</label>
                                    <input type="text" id="name" value="{{$data->name}}" class="theme-input-style @error('name') is-invalid @enderror " name="name" >
                                     @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                
                                       <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Banner Type</label>
                                     <select class="form-control banner_type @error('banner_type') is-invalid @enderror select2" style="width: 100%;" id="banner_type" name="banner_type" onchange="showhideproductCategory()">
                                    <option value="">Select Type</option>
                                    <option value="category" {{('category' == $data->banner_type) ? 'selected': ''}}>Category</option>
                                    <option value="product" {{('product' == $data->banner_type) ? 'selected': ''}}>Product</option>
                                    </select>
                                     @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                
                                      <div class="form-group mb-4 cat_div" style="display:none;">
                                    <label for="email1" class="mb-2 black bold">Category</label>
                                     <select class="form-control @error('category_id') is-invalid @enderror select2" style="width: 100%;" id="category_id" name="category_id">
                                    <option value="">Select Category</option>
                                   @foreach($category as  $cat)
                                    <option value="{{$cat->id}}" {{($cat->id == $data->category_id) ? 'selected': ''}}>{{$cat->name}}</option>
                                    @endforeach
                                    </select>
                                     @error('link')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                
                                      <div class="form-group mb-4 pro_div" style="display:none;">
                                    <label for="email1" class="mb-2 black bold">Product</label>
                                     <select class="form-control @error('product_id') is-invalid @enderror select2" style="width: 100%;" id="product_id" name="product_id">
                                    <option value="">Select Product</option>
                                   @foreach($product as  $pro)
                                    <option value="{{$pro->id}}" {{($cat->id == $data->product_id) ? 'selected': ''}}>{{$pro->name}}</option>
                                    @endforeach
                                    </select>
                                     @error('link')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>


                                <!-- Form Group -->
                                <div class="form-group mb-4">
                                    <label for="password1" class="mb-2 black bold">Banner Image</label>
                                    <input type="file" name="image" class="theme-input-style" id="image" >
                                     @if($data->image)
                                            <img src="{{env('APP_URL')}}{{$data->image}}" height="50px" width="50px"/>
                                        @endif
                                </div>
                                
                                  <div class="form-group mb-4">
                                    <label for="password1" class="mb-2 black bold"> Order</label>
                                    <input type="number" name="sort_order" class="@error('sort_order') is-invalid @enderror theme-input-style" id="sort_order"  value="{{$data->sort_order}}" >
                                       @error('sort_order')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                   
                                </div>
                                  <div class="col-md-3">
                <div class="form-group mb-4">
               <label for="text_on_banner">Show Text On Banner:</label>
                   <input id="text_on_banner" name="text_on_banner" type="checkbox" value="1" class="" {{ $data->text_on_banner == 1 ? 'checked' : '' }}>

                 
                </div>
            </div>
                                <!-- End Form Group -->

                               
                                <!-- Button Group -->
                                <div class="button-group pt-1">
                                    <button type="submit" class="btn long">Submit</button>
                                    <button type="reset" class="link-btn bg-transparent ml-3 soft-pink">Cancel</button>
                                </div>
                                <!-- End Button Group -->
                            </form>
                            <!-- End Form -->
                        </div>
                        <!-- End Base Control -->

                       
                    </div>
                </div>
            </div>            
                    
         </div>
         <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
         <script>
         $(document).ready(function() {
  // Function to be executed when the page loads
  showhideproductCategory();
});
             function showhideproductCategory(){
                 var banner_type = $('.banner_type').val();
                 if(banner_type == 'category'){
                     $('.cat_div').show();
                     $('.pro_div').hide();
                 }else if(banner_type == 'product'){
                     $('.cat_div').hide();
                     $('.pro_div').show();
                 }
             }
         </script>
@endsection
