@extends('admin.layouts.app')
@section('title','All Categories')
@section('content')

      <!-- Main Content -->
         <div class="main-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <!-- Card -->
                        <div class="card bg-transparent">
                            <div class="card-body bg-white">
                                <h4 class="pl-2 pt-2 pb-2">Reels List</h4>
                            </div>

                            <div class="table-responsive">
                                <table class="order-list-table text-nowrap dh-table">
                                    <thead class="bg_dark">
                                        <tr>
                                            <th>ID </th>
                                            <th>User Name</th>
                                            <th>Product Name</th>
                                            <th>Reel</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white">
                                     @if(!empty($reelsData))
                                        @foreach($reelsData as $reelData)
                                        <tr>
                                            <td>{{$reelData->id}}</td>
                                            <td>{{$reelData->userName}}</td>
                                            <td>{{ $reelData->product_names}}</td>
                                            <td>
                                                
                                                 <video width="200" height="200" controls>
                                                    <source src="{{env('APP_URL')}}{{$reelData->reel}}" type="video/mp4">
                                                    Your browser does not support the video tag.
                                                </video>
                                            </td>
                                            <td>
                                                @if($reelData->is_approved == 1)<button type="button" class="status-btn paid">Approved</button>
                                                @elseif($reelData->is_approved == 0)
                                                <button type="button" class="status-btn un_paid">Not Approved</button>
                                                @else
                                                <button type="button" class="status-btn on_hold">Rejected</button>
                                                @endif
                                                </td>
                                           <td>
                                               @if($reelData->is_approved == 0)
                                               {!! Html::decode(link_to_route('admin.status.reels','<i class="icofont-check-alt"></i>',[$reelData->id, 1],['class'=>'btn btn-primary','title'=>'Click To Approve' ,'onclick'=>'return changeStatus();'])) !!}
                                               {!! Html::decode(link_to_route('admin.status.reels','<i class="icofont-close"></i>',[$reelData->id, 2],['class'=>'btn btn-primary','title'=>'Click To Reject' ,'onclick'=>'return changeStatus();'])) !!}
                                                       
                                               @endif
                                             </td>
                                        </tr>
                                        @endforeach
                                    @endif

                                        
                                   
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
         </div>
         <!-- End Main Content -->
@endsection
