
@extends('admin.layouts.app')
@section('title','All Categories')
@section('content')

      <!-- Main Content -->
         <div class="main-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <!-- Card -->
                        <div class="card bg-transparent">
                            <div class="card-body bg-white">
                                <h4 class="pl-2 pt-2 pb-2">Product Review List</h4>
                            </div>

                            <div class="table-responsive">
                                <table class="order-list-table text-nowrap dh-table">
                                    <thead class="bg_dark">
                                        <tr>
                                           <th width="5%">Id</th>
                                         <th width="15%">Product Name</th>
                                         <th width="15%">User Name</th>
                                        <th width="10%">Review </th>
                                        <th width="15%">Rating </th>
                                        <th width="10%">Status</th>
                                        <th width="15%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white">
                                     @if(!empty($data))
                                     @foreach($data as $val)
                                        <tr>
                                           
                                          <td>{{$loop->iteration}}</td>
                                        <td>{{$val->product_name}}</td>
                                        <td>{{$val->user_name}}</td>
                                        <td>{{$val->review}}</td>
                             
                                        <td>
                                        <div class="rating-stars">
                                            @for($i = 1; $i <= 5; $i++)
                                                @if($i <= $val->rating)
                                                    <span class="filled-star" style="color: #d6a916;">&#9733;</span>
                                                @else
                                                    <span class="empty-star">&#9733;</span>
                                                @endif
                                            @endfor
                                        </div>
                                    </td>


                					  <td>
                							@if($val->status == 1)
                								<span class="label label-success" >Approved </span>
                							@else
                								<span class="label label-warning" >Not Approved </span>
                							@endif
                						</td>
					
                                        <td>
                                               @if($val->status == 1)
        							
        								{!! Html::decode(link_to_route('admin.status.review','Not Approve',[$val->id, 0],['class'=>'btn btn-success','title'=>'Click To Not Approve' ,'onclick'=>'return changeStatus();'])) !!}
        							@else
        							
        								
        									{!! Html::decode(link_to_route('admin.status.review','Approve',[$val->id, 1],['class'=>'btn btn-success','title'=>'Click To Approve','onclick'=>'return changeStatus();'])) !!}
        							@endif 
                                    
                                    </td>
                                        </tr>
                                        @endforeach
                                    @endif
                                        

                                   
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
         </div>
         <!-- End Main Content -->
@endsection


