@extends('admin.layouts.app')
@section('title','Add Product')

@section('content')

   <div class="main-content d-flex justify-content-center align-items-center">
             
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <!-- Base Control -->
                        <div class="form-element py-30 multiple-column">
                            <h4 class="font-20 mb-4">Add Product</h4>

                            <!-- Form -->
                                  {!! Form::open(['role' => 'form','route' => "admin.save.product",'class' => '','method' => 'post', 'files' => true]) !!}
                                @csrf
                                <!-- Form Group -->
                                  <div class="row">
                                        <div class="col-lg-6">
                                           <div class="form-group mb-4">
                                    <label for="category" class="mb-2 black bold">Product Category*</label>
                                    {!! Form::select('category_id', $categories, '', ['class' => 'form-control cat_id', 'placeholder' => 'Select Category', 'required' => 'required']) !!}
                                    <span style="color:red">{{ $errors->first('category') }}</span>
                                </div>   
                                <div class="form-group ">
                                    <label for="name" class="mb-2 black bold">Product Name*</label>
                                     {!! Form::text('name', '',['class' => 'form-control', 'placeholder' => 'Enter Please Product Name']) !!}
                                    <span class="" style="color:red"> {{ $errors->first('name')}} <span>
                                </div>
                                <div class="form-group ">
                                    <label for="us_link" class="mb-2 black bold">Link For US & Canada</label>
                                     {!! Form::text('us_link', '',['class' => 'form-control' , 'placeholder' => 'Enter Please US & Canada links ']) !!}
                                    <span class="" style="color:red"> {{ $errors->first('us_link')}} <span>
                                </div>
                               
                                  <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Manufacturer Name</label>
                                   {!! Form::text('manufacturer' ,'', ['class'=>'form-control','placeholder'=>'Enter Manufacturer']) !!}
                                    <span class="" style="color:red"> {{ $errors->first('manufacturer')}} <span>
                                </div>
                                  <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Material Name*</label>
                                   {!! Form::text('material' ,'', ['class'=>'form-control','placeholder'=>'Enter Material']) !!}
                                    <span class="" style="color:red"> {{ $errors->first('material')}} <span>
                                </div>
                               
                                  <div class="form-group mb-4">
                                <label class="mb-2 black bold">Front Image </label>
    
                                            {{ Form::file("front_image", ['class'=>'form-control']) }}
                                <span class="" style="color:red"> {{ $errors->first('front_image')}} <span>
                                
                                    </div>
                                    <div class="form-group mb-4">
                                    <label class="mb-2 black bold">Hover Image </label>
    
                                            {{ Form::file("hover_image", ['class'=>'form-control']) }}
                                <span class="" style="color:red"> {{ $errors->first('hover_image')}} <span>
                                    </div>
                                    
                                   <!--<div class="form-group mb-4">-->
                                   <!--     <label for="email1" class="mb-2 black bold">Long Description</label>-->
                                   <!--     <textarea name="long_description" id="long_description" class="form-control" rows="4"></textarea>-->
                                   <!--     <span class="" style="color:red">{{ $errors->first('long_description') }}</span>-->
                                   <!-- </div>-->
                                    
                                    <div class="form-group mb-4">
                                        <label for="how_to_use" class="mb-2 black bold">How to Use</label>
                                        <textarea name="how_to_use" id="how_to_use" class="form-control" rows="4" placeholder="Enter Please" ></textarea>
                                        <span class="" style="color:red">{{ $errors->first('how_to_use') }}</span>
                                    </div>

                                    
                                            </div>
                                            
            
                                 <div class="col-lg-6">
                                     <div class="form-group mb-4">
                                    <label for="sub_category_id" class="mb-2 black bold">Product Sub Category</label>
                                    {!! Form::select('sub_category_id', [], '', ['class' => 'form-control sub_cat_id', 'placeholder' => 'Select Sub Category' ]) !!}
                                    <span style="color:red">{{ $errors->first('sub_category_id') }}</span>
                                </div>
                                
                                <div class="form-group ">
                                    <label for="sku_no" class="mb-2 black bold">Product Sku No</label>
                               
                                           <div class="theme-input-group style--two">
                                            {!! Form::text('sku_no', '',['class' => 'form-control pd sku_no', 'placeholder' => 'Enter Please Sku No']) !!}
                                            <div class="input-group-append">
                                                <button type="button" class="btn style--three" onClick="checkSkuExist()">Check Sku</button>
                                            </div>
                                        </div>
                                        <span class="" style="color:red"> {{ $errors->first('sku_no')}} <span>
                                </div>
                                
                                <!--<div class="form-group ">-->
                                <!--    <label for="canada_link" class="mb-2 black bold">Link For CANADA</label>-->
                                <!--     {!! Form::text('canada_link', '',['class' => 'form-control']) !!}-->
                                <!--    <span class="" style="color:red"> {{ $errors->first('canada_link')}} <span>-->
                                <!--</div>-->
                                
                                   <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Product Color*</label>
                                   {!! Form::select('color_id',$colors ,'', ['class'=>'form-control','placeholder'=>'Select Color']) !!}
                                    <span class="" style="color:red"> {{ $errors->first('color_id')}} <span>
                                </div>
                                
                                  <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Product Weight</label>
                                   {!! Form::text('weight' ,'', ['class'=>'form-control','placeholder'=>'Enter Weight']) !!}
                                    <span class="" style="color:red"> {{ $errors->first('weight')}} <span>
                                </div>
                                  <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Package Diamention</label>
                                   {!! Form::text('package_diamention' ,'', ['class'=>'form-control','placeholder'=>'Enter Package Diamention']) !!}
                                    <span class="" style="color:red"> {{ $errors->first('package_diamention')}} <span>
                                </div>
                                
                                <div class="form-group mb-4">
                                     <label class="mb-2 black bold">Multiple Images </label>
                                            {{ Form::file("images[]", ['class'=>'form-control','multiple']) }}
                                <span class="" style="color:red"> {{ $errors->first('sd')}} <span>
                                
                                    </div>
                                  
                                  <div class="form-group mb-4">
                                        <label for="email1" class="mb-2 black bold">Short Description</label>
                                        <textarea name="description" id="description" class="form-control" rows="4" placeholder="Enter Please Short Descriptions"></textarea>
                                        <span class="" style="color:red">{{ $errors->first('description') }}</span>
                                    </div>
                                  
    
                                </div>
                               
                                 </div>
                                 
                                       <div class="hr-line-dashed"></div>
                             
							     <div class="form-group  row">
                                     <h3>Size Section </h3>
                            <?php $counter = 0; ?>
                                </div>
							  <div class="moduleHolder">
                             
								
								<div class="form-group  row">
                                
                                  <div class="col-md-12">
						 
					
							<table class="table table-bordered moduleSectionRow_{{$counter}}">
								
							
								<thead>
								<th width="15%"><center>{{ trans("Size") }}</center></th> 
									<th width="10%"><center>{{ trans("Price") }}(INR)</center></th> 
									<th width="10%"><center>{{ trans("Sell Price") }}(INR)</center></th>  
									<!--<th width="10%"><center>{{ trans("Price") }}(USD)</center></th> -->
									<!--<th width="10%"><center>{{ trans("Sell Price") }}(USD)</center></th>  -->
									
										<th width="10%"><center>{{ trans("Stock") }}</center></th> 
									<th width="10%"><center></center></th> 
								   
								</thead>
							  
								<tr class="panel panel-default delete_module_section_row_{{$counter}}" rel="{{$counter}}">
								
								<td>		
										<div class="mws-form-item">
										 {!! Form::select("modules[$counter][size_id]",$sizes,'', ['class'=>'form-control']) !!}
										<span class="" style="color:red"> {{ $errors->first('queans')}} <span>
										</div> 
									
									</td>
									<td>	
									    	<div class="mws-form-item">
										 {!! Form::number("modules[$counter][price]",'', ['class'=>'form-control']) !!}
										<span class="" style="color:red"> {{ $errors->first('price')}} <span>
										</div> 
									
									</td>
										<td>	
									    	<div class="mws-form-item">
										 {!! Form::number("modules[$counter][sell_price]",'', ['class'=>'form-control']) !!}
										<span class="" style="color:red"> {{ $errors->first('sell price')}} <span>
										</div> 
									
									</td>
										{{--<td>	
									    	<div class="mws-form-item">
										 {!! Form::number("modules[$counter][price_usd]",'', ['class'=>'form-control']) !!}
										<span class="" style="color:red"> {{ $errors->first('queans')}} <span>
										</div> 
									
									</td>
										<td>	
									    	<div class="mws-form-item">
										 {!! Form::number("modules[$counter][sell_price_usd]",'', ['class'=>'form-control']) !!}
										<span class="" style="color:red"> {{ $errors->first('queans')}} <span>
										</div> 
									
									</td>--}}
									
										<td>	
									    	<div class="mws-form-item">
										 {!! Form::number("modules[$counter][stock]",'', ['class'=>'form-control']) !!}
										<span class="" style="color:red"> {{ $errors->first('stock')}} <span>
										</div> 
									
									</td>
									
									<td>
									    <input style="float:right;" type="button" value="Add More" class="btn btn-primary btn-sm add_more_btn" onclick="add_more_module_question_section({{$counter}});"/>
									</td>
									
									
								</tr>
								
							</table>
							</div>
                               
                                
								</div>
								
								
                                    </div>
                                <!-- End Form Group -->

                                <!-- End Form Group -->

                               
                                <!-- Button Group -->
                                <div class="button-group pt-1">
                                    <button type="submit" class="btn long">Submit</button>
                                    <button type="reset" class="link-btn bg-transparent ml-3 soft-pink">Cancel</button>
                                </div>
                                <!-- End Button Group -->
                            </form>
                            <!-- End Form -->
                        </div>
                        <!-- End Base Control -->

                       
                    </div>
                </div>
            </div>            
                    
         </div>
         <script>
               	function add_more_module_section(){  
		var count = $('#add_more_count').val();
		var new_count = parseInt(count)+parseInt(1);
		$.ajax({
			headers: {
			 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
		url			:	'{{ route("ajaxRequest.addMoreModuleSection") }}',
			type		:	'post',
			data		:	{'counter':new_count},
			async : false,
			success: function(r){
				if(r ) {
					$('#add_more_count').val(new_count);
					$('.moduleHolder').append(r);
					alert('Color Section Added Successfully')
				}else{
					alert('There is an error please try again.')
				}
			}
		});
	}
	
	
		function add_more_module_question_section(counter){  
		$('#loader_img').show();
		var get_last_id	=	$(".moduleSectionRow_"+counter).find('tr').last().attr('rel');
		var moduleQueCount  	= 	parseInt(get_last_id) + 1; 
		 $.ajaxSetup({
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        }
                                    });
	 $.ajax({
			url			:	'{{ route("ajaxRequest.addMoreModuleQuestionSection") }}',
			type		:	'post',
			data		:	{'counter':moduleQueCount},
			success		:	function(response){ 
				$('.moduleSectionRow_'+counter ).find('tr').last().after(response); 
				$('#loader_img').hide();
			},
			error:function(response){ 
				$('#loader_img').hide();
			}
		});
	}
	

        function del_module_question_answer_row(row_id) {
	    url = $(this).attr('href');
          
                    
                     swal({
                title: "Are you sure?",
                text: "Want to remove this?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                closeOnConfirm: true
            }, function () {
                $('.delete_module_section_row_'+row_id).remove(); 
                
            });
        } 
        function checkSkuExist(){
                var sku = $( ".sku_no" ).val();
                 $.ajaxSetup({
          
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        }
                                    });
             
                                        $.ajax({
                                        type:'POST',
                                        url:"{{ route('ajaxRequest.chk_sku') }}",
                                        data:{sku:sku},   
                                        success:function(data){
                                            //alert(data);
                                            if(data == 1){
                                                alert("Sku No Already Exist.")
                                            }else{
                                                alert("Sku Not Exist.")
                                            }
                                        }
                                        });
            }
            
            
     
            
         </script>
<script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('how_to_use');
    CKEDITOR.replace('description');
</script>


@endsection

