@extends('admin.layouts.app')
@section('title','All Categories')
@section('content')

<style>
    .rounded-input {
    border-radius: 20px;
    padding: 8px 12px;
    border: 1px solid #ced4da;
     background-color:#f0f0f0;
}

.filter-btn {
    background-color: #007bff;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 20px;
    cursor: pointer;
}

.reset-btn {
    background-color: #dc3545;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 20px;
    cursor: pointer;
    margin-left: 10px;
}

/* Responsive styles */
@media screen and (max-width: 768px) {
    .rounded-input,
    .filter-btn,
    .reset-btn {
        margin-top: 10px;
    }
}

</style>

      <!-- Main Content -->
         <div class="main-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <!-- Card -->
                        <div class="card">
                       <div class="card-body pt-30">
                           <!--<button id="exportToExcelBtn" class="btn btn-primary">Export to Excel</button>-->
                          <div class="btn-group">
                            <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                Export
                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="#" id="exportToExcel"><i class="fas fa-file-excel"></i> CSV</a>
                                <!--<a class="dropdown-item" href="#" id="exportToSVG"><i class="fas fa-file-code"></i> SVG</a>-->
                                <!--<a class="dropdown-item" href="#" id="exportToPNG"><i class="fas fa-file-image"></i> PNG</a>-->
                                <a class="dropdown-item" href="#" id="copyTable"><i class="fas fa-copy"></i> Copy</a>
                                <a class="dropdown-item" href="#" id="printTable"><i class="fas fa-print"></i> Print</a>
                            </div>
                        </div>


                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <h4 class="font-20"> Order List</h4>
                                    </td>
                                    <td class="text-right">
                                        <form action="#" class="search-form">
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="searchInput"
                                                    placeholder="Search Here">
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                   
                  <div class="card-body pt-30">
                            <div class="row">
                                <div class="col-md-12">
                                    <form id="filterForm" method="GET" class="filter-form">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label for="startDate"><b>Start Date:</b></label>
                                                <input type="date" id="startDate" name="startDate" class="form-data rounded-input" value="{{ request('startDate') }}">
                                            </div>
                                            <div class="col-md-3">
                                                <label for="endDate"><b>End Date:</b></label>
                                               <input type="date" id="endDate" name="endDate" class="form-data rounded-input" value="{{ request('endDate') }}" max="{{ date('Y-m-d') }}">
                        
                                            </div>
                                            <div class="col-md-3">
                                                <div class="d-flex align-items-center">
                                                    <label for="orderStatus"><b>Status:</b></label>
                                                    <select id="orderStatus" name="orderStatus" class="form-data rounded-input ml-2">
                                                        <option value="">Select Status</option>
                                                        <option value="Pending" {{ request('orderStatus') == 'Pending' ? 'selected' : '' }}>Pending</option>
                                                        <option value="Confirmed" {{ request('orderStatus') == 'Confirmed' ? 'selected' : '' }}>Confirmed</option>
                                                        <option value="Shipped" {{ request('orderStatus') == 'Shipped' ? 'selected' : '' }}>Shipped</option>
                                                        <option value="Delivered" {{ request('orderStatus') == 'Delivered' ? 'selected' : '' }}>Delivered</option>
                                                        <option value="Cancelled" {{ request('orderStatus') == 'Cancelled' ? 'selected' : '' }}>Cancelled</option>
                                                    </select>
                                                </div>
                                            </div>
                        
                                            <div class="col-md-3">
                                                <button type="submit" class="filter-btn">Filter</button>
                                                <button type="button" class="reset-btn" onclick="window.location.href='{{ route('admin.list.orders') }}'">Reset</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        
                            <div id="result"></div>
                        </div>
                            <div class="table-responsive">
                                <table id="orderTable" class="text-nowrap bg-white dh-table">
                                    <thead class="bg_dark">
                                        <tr>
                                            <th>Date <img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                            <th>Order Number <img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                            <th>Customer Name <img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                            <th>Product Name</th>
                                            <th>Grand Total(Rs) <img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                            <th>Status</th>
                                             <th>Update</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white">
                                     @if(!empty($orders))
                                     @foreach($orders as $orderData)
                                        <tr>
                                           <td>{{ \Carbon\Carbon::parse($orderData->created_at)->format('d M Y') }}</td>
                                            <td>{{$orderData->order_number}}</td>
                                            <td>{{$orderData->userName}}</td>
                                            <td>
                                                @foreach($orderData->orderDetails as $orderDetail)
                                                    @if ($orderDetail->product)
                                                        {{ Str::limit($orderDetail->product->name, 20, '...') }}
                                                    @else
                                                        Product Not Found
                                                    @endif
                                                    @if (!$loop->last)
                                                        </br> <!-- Add a comma if it's not the last product -->
                                                    @endif
                                                @endforeach
                                            </td>
                                             <td>{{$orderData->order_amount_after_discount}}</td>
                                           <td>
                                                    @php
                                                        $statusColor = '';
                                                        switch ($orderData->order_status) {
                                                            case 'Pending':
                                                                $statusColor = '#ff91008f';
                                                                break;
                                                            case 'Confirmed':
                                                                $statusColor = '#00802199';
                                                                break;
                                                            case 'Shipped':
                                                                $statusColor = '#00e0ffba';
                                                                break;
                                                            case 'Delivered':
                                                                $statusColor = '#9100ffa1';
                                                                break;
                                                            case 'Cancelled':
                                                                $statusColor = '#ff0000a3';
                                                                break;
                                                            default:
                                                                $statusColor = 'gray'; 
                                                                break;
                                                        }
                                                    @endphp
                                                    <button type="button" class="status-btn paid" style="background-color: {{ $statusColor }}">{{ $orderData->order_status }}</button>
                                                </td>
                                             {{--<td>@if($orderData->payment_mode == 'ccavenue')<button type="button" class="status-btn paid">{{$orderData->payment_status}}</button>@endif</td>--}}
                                           <td>
                                                <form method="POST" action="{{ route('update.order.status', ['id' => $orderData->id]) }}">
                                                @csrf
                                                @method('POST')
                                                <div class="dropdown">
                                                    <button class="details-btn dropdown-toggle" type="button" id="statusDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Status
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="statusDropdown">
                                                        <button type="submit" class="dropdown-item" name="status" value="Pending">Pending</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Confirmed">Confirmed</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Shipped">Shipped</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Delivered">Delivered</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Cancelled">Cancelled</button>
                                                    </div>
                                                </div>
                                            </form>

                                            </td>
                                           <td><a href="{{route('admin.detail.order',$orderData->id)}}" class="details-btn">Invoice <i class="icofont-arrow-right"></i></a></td>
                                        </tr>
                                        @endforeach
                                    @endif
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
         </div>
         <!-- End Main Content -->
          <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
          <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.0/xlsx.full.min.js"></script>
          <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js"></script>
          <!--<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js"></script>-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>


        <script>
    $(document).ready(function() {
        $(".three-dots").click(function() {
            var userId = $(this).data('userid');

            $("#user-id").val(userId);
        });
    });
    
     $(document).ready(function () {
        $("#searchInput").on("keyup", function () {
            var value = $(this).val().toLowerCase();
            $("#orderTable tbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        });
    });
    
    
 document.getElementById('exportToExcel').addEventListener('click', function() {
    exportTable('xlsx', 'orders.xlsx');
});

document.getElementById('exportToSVG').addEventListener('click', function() {
    exportToSVG('orders.svg');
});

document.getElementById('exportToPNG').addEventListener('click', function() {
    exportToPNG('orders.png');
});

function exportTable(format, fileName) {
    var table = document.getElementById('orderTable');
    var workbook = XLSX.utils.table_to_book(table, {sheet: "Sheet 1"});
    var excelBuffer = XLSX.write(workbook, {bookType: format, type: 'array'});
    var blob = new Blob([excelBuffer], {type: 'application/octet-stream'});
    var downloadLink = document.createElement('a');
    downloadLink.href = window.URL.createObjectURL(blob);
    downloadLink.download = fileName;
    downloadLink.click();
}

function exportToSVG(fileName) {
    var table = document.getElementById('orderTable');
    html2canvas(table).then(function(canvas) {
        var svgData = canvas.toDataURL("image/svg+xml");
        var downloadLink = document.createElement('a');
        downloadLink.href = svgData;
        downloadLink.download = fileName;
        downloadLink.click();
    });
}

function exportToPNG(fileName) {
    var table = document.getElementById('orderTable');
    html2canvas(table).then(function(canvas) {
        var pngData = canvas.toDataURL("image/png");
        var downloadLink = document.createElement('a');
        downloadLink.href = pngData;
        downloadLink.download = fileName;
        downloadLink.click();
    });
}

document.getElementById('copyTable').addEventListener('click', function() {
    var table = document.getElementById('orderTable');
    var range = document.createRange();
    range.selectNode(table);
    window.getSelection().removeAllRanges();
    window.getSelection().addRange(range);
    document.execCommand('copy');
    window.getSelection().removeAllRanges();
    alert('Table copied to clipboard!');
});

document.getElementById('printTable').addEventListener('click', function() {
    window.print();
});


</script>
@endsection
