@extends('admin.layouts.app')
                   
@section('content')

         <div class="wrapper main-wrapper row" style=''>

                <div class='col-xs-12'>
                    <div class="page-title">

                        <div class="pull-left">
                            <!-- PAGE HEADING TAG - START -->
                            <h1 class="title">FAQ</h1>
                            <!-- PAGE HEADING TAG - END -->
                        </div>

                    </div>
                </div>
                <div class="clearfix"></div>
                <!-- MAIN CONTENT AREA STARTS -->


                <div class="col-lg-12">
                    <section class="box ">
                        <header class="panel_header">
                            <h2 class="title pull-left">Add Faq</h2>
                           
                        </header>
                        <div class="content-body">
                            {!! Form::open(['role' => 'form','route' => "faq.save",'method' => 'post', 'files' => true]) !!}
                           
                                <div class="row">

                                    <div class="col-xs-12">

                                        <div class="form-group">
                                            <label class="form-label">Question*</label>
                                            <div class="controls">
                                                 {{ Form::text('question', '',['class' => 'form-control','style'=>'text-transform: capitalize']) }}
                                                   @error('question')
                                                        <span class="error" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror                                                                                       
                                            </div>
                                        </div>
                                        
                                           <div class="form-group">
                                            <label class="form-label">Answer*</label>
                                            <div class="controls">
                                                 {{ Form::textarea('answer', '',['class' => 'form-control','style'=>'text-transform: capitalize','rows'=>3]) }}
                                                   @error('answer')
                                                        <span class="error" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror                                                                                       
                                            </div>
                                        </div>

                                        

                                        


                                     

                                    </div>


                                    <div class="col-xs-12">
                                        <div class="pull-right ">
                                            <button type="submit" class="btn btn-primary">Save</button>
                                            <button type="button" class="btn">Cancel</button>
                                        </div>
                                    </div>

                                </div>

                        {!! Form::close() !!}

                        </div>
                    </section>
                    
                      </div>
                 <div class="col-lg-12">
                    <section class="box">
                        <header class="panel_header">
                            <h2 class="title pull-left">List Faq</h2>
                            
                        </header>
                        <div class="content-body">
                            <div class="row">
                                <div class="col-xs-12">

                                   <!-- Bootstrap FAQ - START -->
                                    <div class="panel-group no-mb faq-panels" id="accordion">
                                        @if(!empty($data))
                                            @foreach($data as $faqData)
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                    <a class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapse{{$faqData->id}}">{{$faqData->question}}</a>
                                                </h4>
                                                    </div>
                                                    <div id="collapse{{$faqData->id}}" class="panel-collapse collapse">
                                                        <div class="panel-body">
                                                            <p>{{$faqData->answer}}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                        
                                        <!-- bs faq end -->

                                </div>
                            </div>
                        </div>
                    </section>
                        
                </div>

                <!-- MAIN CONTENT AREA ENDS -->
            </div>
       
@endsection
