@extends('admin.layouts.app')
@section('title','All Categories')
@section('content')

  <div class="main-content">
                <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card mb-30">
                   <div class="card-body pt-30">
                                   
                                     <table>
                                       <tbody><tr><td> <h4 class="font-20 ">Fabric List</h4></td><td><a href="{{route('fabric.add')}}" class="btn long">Add new Fabric</a></td></tr>
                                   </tbody></table>
                                </div>
                              
              <!-- /.card-header -->
              <div class="table-responsive">
                <table class="text-nowrap bg-white dh-table">
                  <thead>
                  <tr>
                    <th>Name</th>
                    <th>Status </th>
                    <th>Action </th>
                  
                  </tr>
                  </thead>
                  <tbody>
                    @if(!empty($result))
                    @foreach($result as $data)
                  <tr>
                   
                    <td>{{$data->name}}</td>
                     <td>
                        @if($data->status == 1)
                     <button type="button" class="btn btn-success  btn-sm"  title="Click To Deactivate"  data-value="block">
                      Active
                     </button>
                     @else
                        <button type="button"class="btn btn-danger  btn-sm" title="Click To Activate" data-value="active">
                          InActive
                     </button>
                     @endif

                     </td>
                     <td>


                         {!! Html::decode(link_to_route('fabric.edit','<i class="icofont-edit"></i>',[$data->id],['class'=>'btn btn-primary','title'=>'Edit'])) !!}  
                     </td>
                    
              
                    
                  </tr>

    
                  @endforeach
                  @endif
              
               
                  </tbody>
                  
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>


@endsection
