@extends('admin.layouts.app')
@section('title','All Categories')
@section('content')

  <div class="main-content">
                <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card mb-30">
                   <div class="card-body pt-30">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="font-20">Coupon List</h4>
                        <a href="{{ route('coupon.add') }}" class="btn long">Add new Coupon</a>
                    </div>
                </div>
              <!-- /.card-header -->
              <div class="table-responsive">
                <table class="text-nowrap bg-white dh-table">
                  <thead class="bg_dark">
                  <tr>
                    <th>S/No.</th>
                    <th>Name</th>
                    <th>Code</th>
                    <th>Percentage(%)</th>
                    <th>Expiry Date</th>
                    <th>Status </th>
                    <th>Action </th>
                  
                  </tr>
                  </thead>
                  <tbody>
                    @if(!empty($result))
                    @foreach($result as $data)
                  <tr>
                   <td>{{$loop->iteration}}</td>
                    <td>{{$data->name}}</td>
                    <td>{{$data->code}}</td>
                    <td>{{$data->percentage}}</td>
                    <td>{{$data->end_date}}</td>
                     {{--<td>
                        @if($data->status == 1)
                     <button type="button" class="btn btn-success  btn-sm"  title="Click To Deactivate"  data-value="block">
                      Active
                     </button>
                     @else
                        <button type="button"class="btn btn-danger  btn-sm" title="Click To Activate" data-value="active">
                          InActive
                     </button>
                     @endif

                     </td>--}}
                     <td>
                   <form action="{{ route('admin.coupon.status', ['id' => $data->id]) }}" method="post">
                        @csrf
                        @method('put')
                    
                        @if($data->is_active == 1)
                            <button type="submit" class="btn btn-sm" title="Click To Deactivate" style="background-color: green; color: white;">activate</button>
                            <input type="hidden" name="action" value="deactivate">
                        @else
                            <button type="submit" class="btn btn-sm" title="Click To Activate" style="background-color: red; color: white;">Deactivate</button>
                            <input type="hidden" name="action" value="activate">
                        @endif
                    </form>

                </td>
                     <td>


                         {!! Html::decode(link_to_route('coupon.edit','<i class="icofont-edit"></i>',[$data->id],['class'=>'btn btn-primary','title'=>'Edit'])) !!}  
                     </td>
                    
              
                    
                  </tr>

    
                  @endforeach
                  @endif
              
               
                  </tbody>
                  
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>


@endsection
