@extends('admin.layouts.app')
@section('title','Edit Category')

@section('content')

   <div class="main-content d-flex justify-content-center align-items-center">
             
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <!-- Base Control -->
                        <div class="form-element base-control mb-30">
                            <h4 class="font-20 mb-4">Edit Category</h4>

                            <!-- Form -->
                            <form method="post" action="{{route('category.update',$category->id)}}" enctype="multipart/form-data">
@csrf
                                <!-- Form Group -->
                                <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Category Name</label>
                                    <input type="text" id="name" value="{{$category->name}}" class="theme-input-style @error('name') is-invalid @enderror " name="name" >
                                     @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <!-- End Form Group -->

                                <!-- Form Group -->
                                <div class="form-group mb-4">
                                    <label for="password1" class="mb-2 black bold">Category Icon</label>
                                    <input type="file" name="image" class="theme-input-style" id="image" >
                                     @if($category->image)
                                            <img src="{{env('APP_URL')}}{{$category->image}}" height="50px" width="50px"/>
                                        @endif
                                </div>
              
                               
                                <!-- Button Group -->
                                <div class="button-group pt-1">
                                    <button type="submit" class="btn long">Submit</button>
                                    <button type="reset" class="link-btn bg-transparent ml-3 soft-pink">Cancel</button>
                                </div>
                                <!-- End Button Group -->
                            </form>
                            <!-- End Form -->
                        </div>
                        <!-- End Base Control -->

                       
                    </div>
                </div>
            </div>            
                    
         </div>
@endsection
