@extends('admin.layouts.app')
@section('content')
<style>
     .three-dots {
        display: inline-block;
        transform: rotate(90deg);
        cursor: pointer;
    }
     element.style {
    position: absolute;
    inset: 0px auto auto 0px;
    margin: 0px;
    transform: translate(-49px, 25px);
}
</style>
          <!-- Main Content -->
         <div class="main-content">
            <div class="container-fluid">
               <div class="row">
                  <div class="col-xl-3 col-sm-3">
                     <!-- Card -->
                     <div class="card mb-30">
                         <a href="{{route('admin.list.product')}}">
                          <div class="card-title"> <span>Total Products</span></div>
                        <div class="state card-body">
                         <div class="d-flex align-items-center flex-wrap">
                              <div class="state-icon d-flex justify-content-center">
                                  <img src="../public/assets/img/png-icon/total-products.png" alt="" width="80"; height="80">
                              </div>
                              <div class="state-content">
                                  <p class="font-14 mb-2">Total Products</p>
                                  <h2>{{$totalProduct}}</h2>
                              </div>
                           </div>
                        </div>
                     </div>
                     </a>
                     <!-- End Card -->
                  </div>

                  <div class="col-xl-3 col-sm-3">
                     <!-- Card -->
                     <div class="card mb-30">
                         <a href="{{route('admin.list.orders')}}">
                          <div class="card-title"> <span>Total Orders</span></div>
                        <div class="state card-body">
                           <div class="d-flex align-items-center flex-wrap">
                              <div class="state-icon d-flex justify-content-center">
                                  <img src="../public/assets/img/png-icon/order.png" alt="" width="80"; height="80">
                              </div>
                              <div class="state-content">
                                  <p class="font-14 mb-2">Total Orders</p>
                                  <h2>{{$totalOrders}}</h2>
                              </div>
                           </div>
                        </div>
                     </div>
                     </a>
                     <!-- End Card -->
                  </div>

                  <div class="col-xl-3 col-sm-3">
                     <!-- Card -->
                     <div class="card mb-30">
                         <a href="{{route('admin.list.user')}}">
                         <div class="card-title"> <span>Total Users</span></div>
                         <div class="state card-body">
                           <div class="d-flex align-items-center flex-wrap">
                              <div class="state-icon d-flex justify-content-center">
                                  <img src="../public/assets/img/png-icon/total-users.png" alt="" width="80"; height="80">
                              </div>
                              <div class="state-content">
                                  <p class="font-14 mb-2">Total Users</p>
                                  <h2>{{$totalUsers}}</h2>
                              </div>
                           </div>
                        </div>
                     </div>
                     </a>
                     <!-- End Card -->
                  </div>

                  <div class="col-xl-3 col-sm-3">
                     <!-- Card -->
                     <div class="card mb-30">
                          <a href="{{route('admin.list.orders')}}">
                         <div class="card-title"> <span>Total Income</span></div>
                        <div class="state card-body">
                           <div class="d-flex align-items-center flex-wrap">
                              <div class="state-icon d-flex justify-content-center">
                                   <img src="../public/assets/img/png-icon/economy-growth.png" alt="" width="80"; height="80">
                              </div>
                              <div class="state-content">
                                  <p class="font-14 mb-2">Total Income</p>
                                  <h2>Rs{{$formattedIncome = $totalIncome >= 1000 ? round($totalIncome / 1000, 1) . 'k' : $totalIncome;}}</h2>
                              </div>
                           </div>
                        </div>
                     </div>
                     </a>
                     <!-- End Card -->
                  </div>
                  
                  <div class="col-xl-12">
                     <!-- Card -->
                     <div class="card addm">
                        <div class="card-body pb-0 title-area">
                           <div class="d-flex justify-content-between">
                              <div class="title-content mb-4">
                                 <h4 class="mb-2"> Recent Payment</h4>
                              </div>

                           </div>
                        </div>
                              
                        <div class="table-responsive">
                         <table class="text-nowrap bg-white dh-table">
                            <thead>
                                <tr>
                                    <th>Order Number</th>
                                    <th>Payment Processed</th>
                                    <th>Payment Received</th>
                                    <th>Payment Cancelled</th>
                                    <!--<th>Action</th>-->
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($orders as $order)
                                    <tr>
                                        <td>{{ $order->order_number }}</td>
                                        <td>
                                            @if($order->order_status === 'Pending' || $order->order_status === 'Confirmed' || $order->order_status === 'Shipped')
                                                Processed
                                                  @else
                                              --
                                            @endif
                                        </td>
                                        <td>
                                            @if($order->order_status === 'Delivered' )
                                                Received
                                                 @else
                                              --
                                            @endif
                                        </td>
                                        <td>
                                            @if($order->order_status === 'Cancelled' )
                                                Cancelled
                                                 @else
                                              --
                                            @endif
                                        </td>
                                        
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                     </div>
                  </div>

                <!-- <div class="col-12">-->
                <!--    <div class="card mb-30">-->
                <!--        <div class="card-body">-->
                <!--            <div class="d-flex justify-content-between align-items-start align-items-sm-center media">-->
                <!--                <div class="d-flex justify-content-start justify-content-sm-between align-items-start align-items-sm-center flex-column flex-sm-row mb-sm-n3  media-body">-->
                <!--                    <div class="title-content mb-4 mb-sm-0">-->
                <!--                        <h4 class="mb-2">Sale Reports</h4>-->
                                        <!--<p>50% Average</p>-->
                <!--                    </div>-->
                <!--                    <ul class="list-inline list-button m-0">-->
                <!--                        <li class="active">Monthly</li>-->
                <!--                        <li>Daily</li>-->
                <!--                        <li>Yearly</li>-->
                <!--                    </ul>-->
                <!--                </div>-->
                <!--                <div class="dropdown-button">-->
                <!--                    <a href="#" data-toggle="dropdown">-->
                <!--                        <div class="menu-icon style--two mt-0 mt-md-1 mr-0 d-flex justify-content-start justify-content-sm-end">-->
                <!--                            <span></span>-->
                <!--                            <span></span>-->
                <!--                            <span></span>-->
                <!--                        </div>-->
                <!--                    </a>-->
                <!--                    <div class="dropdown-menu dropdown-menu-right">-->
                <!--                        <a href="#">Report</a>-->
                <!--                        <a href="#">FAQ</a>-->
                <!--                        <a href="#">Charts</a>-->
                <!--                        <a href="#">Chat</a>-->
                <!--                        <a href="#">Settings</a>-->
                <!--                    </div>-->
                <!--                </div>-->
                <!--            </div>-->
                <!--        </div>-->
                <!--        <div id="apex_line4-chart"></div>-->
                <!--    </div>-->
                <!--</div>-->


              
                  <!--<div class="col-xl-2 col-lg-2 col-sm-6">-->
                  <!--    Card -->
                  <!--   <div class="card mb-30 progress_6 extrs">-->
                  <!--      <div class="card-body">-->
                  <!--         <div class="progress-title">-->
                  <!--            <h4 class="mb-1">sales</h4>-->
                  <!--         </div>-->

                  <!--         <div class="ProgressBar-wrap position-relative mb-5">-->
                  <!--            <div class="ProgressBar ProgressBar_6" data-progress="35">-->
                  <!--               <svg class="ProgressBar-contentCircle" viewBox="0 0 200 200">-->
                  <!--                   on défini le l'angle et le centre de rotation du cercle -->
                  <!--                  <circle transform="rotate(135, 100, 100)" class="ProgressBar-background" cx="100" cy="100" r="8" />-->
                  <!--                  <circle transform="rotate(135, 100, 100)" class="ProgressBar-circle" cx="100" cy="100" r="85" />-->
                  <!--               </svg>-->
                  <!--               <span class="ProgressBar-percentage--text">Increase</span>-->
                  <!--               <span class="ProgressBar-percentage ProgressBar-percentage--count"></span>-->
                  <!--            </div>-->
                  <!--         </div>-->
                           

                         
                  <!--      </div>-->
                  <!--   </div>-->
                  <!--    End Card -->
                  <!--</div>-->

                  <!--<div class="col-xl-2 col-lg-2 col-sm-6">-->
                  <!--    Card -->
                  <!--   <div class="card mb-30 progress_7 extrs">-->
                  <!--      <div class="card-body">-->
                  <!--         <div class="progress-title">-->
                  <!--            <h4 class="mb-1">Company Growth</h4>-->
                  <!--         </div>-->

                  <!--         <div class="ProgressBar-wrap position-relative mb-5">-->
                  <!--            <div class="ProgressBar ProgressBar_7" data-progress="70">-->
                  <!--               <svg class="ProgressBar-contentCircle" viewBox="0 0 200 200">-->
                  <!--                   on défini le l'angle et le centre de rotation du cercle -->
                  <!--                  <circle transform="rotate(135, 100, 100)" class="ProgressBar-background" cx="100" cy="100" r="8" />-->
                  <!--                  <circle transform="rotate(135, 100, 100)" class="ProgressBar-circle" cx="100" cy="100" r="85" />-->
                  <!--               </svg>-->
                  <!--               <span class="ProgressBar-percentage--text">-->
                  <!--                  Increase-->
                  <!--               </span>-->
                  <!--               <span class="ProgressBar-percentage ProgressBar-percentage--count"></span>-->
                  <!--            </div>-->
                  <!--         </div>-->
                           

                        
                  <!--      </div>-->
                  <!--   </div>-->
                  <!--    End Card -->
                  <!--</div>-->
                  <!--   </div>-->
                  <!--</div>-->
                  <div class="col-xl-12">
                     <!-- Card -->
                     <div class="card addm">
                        <div class="card-body pb-0 title-area">
                           <div class="d-flex justify-content-between">
                              <div class="title-content mb-4">
                                    <h4 class="mb-2" style="display: inline-block;">Recent Orders</h4>
                                    </div>
                                <div style="float: right;">
                                    <a href="{{ route('admin.list.orders') }}" style="color: white;"><b>View All</b></a>
                                </div>



                              <!-- Dropdown Button --> 
                              <!--<div class="dropdown-button">-->
                              <!--   <a href="#" class="d-flex align-items-center" data-toggle="dropdown">-->
                              <!--      <div class="menu-icon style--two mr-0 d-flex justify-content-center">-->
                              <!--         <span></span>-->
                              <!--         <span></span>-->
                              <!--         <span></span>-->
                              <!--      </div>-->
                              <!--   </a>-->
                              <!--   <div class="dropdown-menu dropdown-menu-right">-->
                              <!--      <a href="#">Report</a>-->
                              <!--      <a href="#">FAQ</a>-->
                              <!--      <a href="#">Charts</a>-->
                              <!--      <a href="#">Chat</a>-->
                              <!--      <a href="#">Settings</a>-->
                              <!--   </div>-->
                              <!--</div>-->
                              <!-- End Dropdown Button -->
                           </div>
                        </div>
                              
                        <div class="table-responsive">
                           <table class="style--three table-centered text-nowrap table-striped table-hover table-sm">
                              <thead>
                                 <tr>
                                    <th>Order Number <img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                    <th>Purchase Date <img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                    <th>Customer <img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                    <th>Grand Total(Rs)<img src="../../assets/img/svg/table-down-arrow.svg" alt="" class="svg"></th>
                                    <th>Payment Mode</th>
                                    <th>Order Status</th>
                                    <th>Update</th>
                                     <!--<th>Paymnet Status</th>-->
                                    <th>Action</th>
                                 </tr>
                              </thead>
                              <tbody>
                                  @if(!empty($orders))
                                     @foreach($orders as $orderData)
                                        <tr>
                                           
                                            <td>{{$orderData->order_number}}</td>
                                            <td>{{$orderData->created_at}}</td>
                                            <td>{{$orderData->user_name}}</td>
                                            <td>{{ $orderData->order_amount_after_discount }}</td>

                                            <td>{{$orderData->payment_mode}}</td>
                                            <!--<td><button type="button" class="status-btn paid">{{$orderData->order_status}}</button></td>-->
                                            <td>
                                                @php
                                                    $statusColor = '';
                                                    switch ($orderData->order_status) {
                                                        case 'Pending':
                                                            $statusColor = '#ff91008f';
                                                            break;
                                                        case 'Confirmed':
                                                            $statusColor = '#00802199';
                                                            break;
                                                        case 'Shipped':
                                                            $statusColor = '#00e0ffba';
                                                            break;
                                                        case 'Delivered':
                                                            $statusColor = '#9100ffa1';
                                                            break;
                                                        case 'Cancelled':
                                                            $statusColor = '#ff0000a3';
                                                            break;
                                                        default:
                                                            $statusColor = 'gray'; // Set a default color for unknown statuses
                                                            break;
                                                    }
                                                @endphp
                                            
                                                <button type="button" class="status-btn paid" style="background-color: {{ $statusColor }};">
                                                    {{ $orderData->order_status }}
                                                </button>
                                            </td>
                                             <td>
                                                <form method="POST" action="{{ route('update.order.status', ['id' => $orderData->id]) }}">
                                                @csrf
                                                @method('POST')
                                                <div class="dropdown">
                                                    <button class="details-btn dropdown-toggle" type="button" id="statusDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        Status
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="statusDropdown">
                                                        <button type="submit" class="dropdown-item" name="status" value="Pending">Pending</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Confirmed">Confirmed</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Shipped">Shipped</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Delivered">Delivered</button>
                                                        <button type="submit" class="dropdown-item" name="status" value="Cancelled">Cancelled</button>
                                                    </div>
                                                </div>
                                            </form>

                                            </td>

                                             {{--<td>@if($orderData->payment_mode == 'ccavenue')<button type="button" class="status-btn paid">{{$orderData->payment_status}}</button>@endif</td>--}}
                                       
                                           <td><a href="{{route('admin.detail.order',$orderData->id)}}" class="details-btn">Details <i class="icofont-arrow-right"></i></a></td>
                                        </tr>
                                        @endforeach
                                    @endif
                                        
                              </tbody>
                           </table>
                        </div>
                     </div>
                     <!-- End Card -->
                     </div>
                     
                     <div class="col-xl-12">
                     <!-- Card -->
                     <div class="card addm">
                        <div class="card-body pb-0 title-area">
                           <div class="d-flex justify-content-between">
                              <div class="title-content mb-4">
                                 <h4 class="mb-2">User List</h4>
                              </div>
                                   <div style="float: right;">
                                    <a href="{{ route('admin.list.user') }}" style="color: white;"><b>View All</b></a>
                                </div>
                           </div>
                        </div>
                              
                        <div class="table-responsive">
                         <table class="text-nowrap bg-white dh-table">
                  <thead>
                  <tr>
                    <th>Name</th>
                     <th>Email</th>
                      <th>Phone Number</th>
                    <th>Status </th>
                    <th>Action</th>
                  
                  </tr>
                  </thead>
                  <tbody>
                    @if(!empty($result))
                    @foreach($result as $data)
                  <tr>
                   
                    <td>{{$data->name}}</td>
                    <td>{{$data->email}}</td>
                    <td>{{$data->phone_number}}</td>
                    <td>
                    <form action="{{ route('admin.user.status', ['id' => $data->id]) }}" method="post">
                        @csrf
                        @method('put')

                        @if($data->status == 1)
                            <button type="submit" class="btn btn-sm" title="Click To Deactivate" style="background-color: green; color: white;">Activate</button>
                            <input type="hidden" name="action" value="deactivate">
                        @else
                            <button type="submit" class="btn btn-sm" title="Click To Deactivate" style="background-color: red; color: white;">Deactivate</button>
                            <input type="hidden" name="action" value="activate">
                        @endif
                    </form>
                </td>
                <td>
                 <div class="dropdown">
                        <span class="three-dots" data-bs-toggle="dropdown" aria-expanded="false" data-userid="{{ $data->id }}">
                            <h3>...</h3>
                        </span>
                        <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton1">
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.user.details', ['id' => $data->id]) }}">View  Details</a>
                            </li>
                            <li>
                                <a class "dropdown-item" href="{{ route('user.edit', ['id' => $data->id]) }}">Edit</a>
                            </li>
                            <!-- <li>
                                <a class "dropdown-item" href="#">Active</a>
                            </li> -->
                        </ul>
                    </div>
                </td>
                     </tr>

    
                  @endforeach
                  @endif
              
               
                  </tbody>
                  
                </table>
                    </div>
                     </div>
                     <!-- End Card -->
                  </div>
                  <div class="col-12">
                    <div class="card mb-30">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start align-items-sm-center media">
                                <div class="d-flex justify-content-start justify-content-sm-between align-items-start align-items-sm-center flex-column flex-sm-row mb-sm-n3  media-body">
                                    <div class="title-content mb-4 mb-sm-0">
                                        <h4 class="mb-2">Sale Reports</h4>
                                    </div>
                                    <!--<ul class="list-inline list-button m-0">-->
                                    <!--    <li class="active">Monthly</li>-->
                                    <!--    <li>Daily</li>-->
                                    <!--    <li>Yearly</li>-->
                                    <!--</ul>-->
                                </div>
                                <!--<div class="dropdown-button">-->
                                <!--    <a href="#" data-toggle="dropdown">-->
                                <!--        <div class="menu-icon style--two mt-0 mt-md-1 mr-0 d-flex justify-content-start justify-content-sm-end">-->
                                <!--            <span></span>-->
                                <!--            <span></span>-->
                                <!--            <span></span>-->
                                <!--        </div>-->
                                <!--    </a>-->
                                    
                                <!--</div>-->
                            </div>
                        </div>
                        <!--<div id="apex_line4-chart"></div>-->
                        <div id="orderChart"></div>
                    </div>
                     <!--<div class="col-xl-2 col-lg-2 col-sm-6">-->
                  <!--    Card -->
                  <!--   <div class="card mb-30 progress_7 extrs">-->
                  <!--      <div class="card-body">-->
                  <!--         <div class="progress-title">-->
                  <!--            <h4 class="mb-1">Company Growth</h4>-->
                  <!--         </div>-->

                  <!--         <div class="ProgressBar-wrap position-relative mb-5">-->
                  <!--            <div class="ProgressBar ProgressBar_7" data-progress="70">-->
                  <!--               <svg class="ProgressBar-contentCircle" viewBox="0 0 200 200">-->
                  <!--                   on défini le l'angle et le centre de rotation du cercle -->
                  <!--                  <circle transform="rotate(135, 100, 100)" class="ProgressBar-background" cx="100" cy="100" r="8" />-->
                  <!--                  <circle transform="rotate(135, 100, 100)" class="ProgressBar-circle" cx="100" cy="100" r="85" />-->
                  <!--               </svg>-->
                  <!--               <span class="ProgressBar-percentage--text">-->
                  <!--                  Increase-->
                  <!--               </span>-->
                  <!--               <span class="ProgressBar-percentage ProgressBar-percentage--count"></span>-->
                  <!--            </div>-->
                  <!--         </div>-->
                           
                </div>
               </div>
            </div>
         </div>
         <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
         <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
         <script>
    $(document).ready(function() {
        $(".three-dots").click(function() {
            var userId = $(this).data('userid');

            $("#user-id").val(userId);
        });
    });
    

    
</script>
<script>
   var orderData = @json($ordersCountByMonth);
var colorScale = ['#FF5733', '#FFC300', '#DAF7A6', '#7FFF00', '#00FFFF', '#0000FF', '#7B68EE', '#FF00FF', '#FF1493', '#FF4500', '#A9A9A9', '#000000'];

var orderCounts = [];
var totalSales = [];
orderData.forEach(data => {
    orderCounts.push(data.total_orders);
    totalSales.push(data.total_sales);
});

var options = {
    series: [{
        name: 'Number of Orders',
        data: orderCounts
    }, {
        name: 'Total Sales',
        data: totalSales
    }],
    chart: {
        type: 'bar',
        height: 350
    },
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: '55%',
            endingShape: 'rounded'
        },
    },
    dataLabels: {
        enabled: false
    },
    stroke: {
        show: true,
        width: 2,
        colors: ['transparent']
    },
    xaxis: {
        categories: [
            "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
        ],
    },
    yaxis: [{
        title: {
            text: 'Number of Orders'
        }
    }, {
        opposite: true,
        title: {
            text: 'Total Sales'
        }
    }],
    fill: {
        colors: colorScale,
        opacity: 1
    },
    tooltip: {
        y: [{
            formatter: function(val) {
                return val + " orders";
            }
        }, {
            formatter: function(val) {
                return '₹' + val.toFixed(2);
            }
        }]
    }
};

var chart = new ApexCharts(document.querySelector("#orderChart"), options);
chart.render();

</script>



    
@endsection