<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory;
      protected $fillable = ['name','slug','image'];

 public function category()
    {
        return $this->hasMany('App\Models\Category','id');
    }


  
    public function reviews()
    {
        return $this->hasMany('App\Models\Review','product_id')->where('reviews.status',1);
    }
    
    public function images() {   
        return $this->hasMany('App\Models\ProductImage');
    }
    
    public function sizes() {   
        return $this->hasMany('App\Models\ProductSize');
    }
    
   public function productSizes()
    {
        return $this->hasMany(ProductSize::class);
    }

    
    public function orders()
    {
        return $this->hasMany(Order::class);
    }
    
     public function color()
    {
        return $this->belongsTo(Color::class, 'color_id');
    }
    
}
