<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    protected $fillable = [
        
        'order_status',
        
    ];

    
       public function order_details() {
        return $this->hasMany(OrderDetail::class);
    }
    
    public function orderDetails()
{
    return $this->hasMany(OrderDetail::class, 'order_id', 'id');
}

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
    
    public function user()
{
    return $this->belongsTo(User::class, 'user_id');
}

}
