<?php

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Support\Facades\View;
use Symfony\Component\HttpKernel\Exception\MaintenanceModeException;


class MaintenanceModeMiddleware
{
    /**
     * The URIs that should be reachable while maintenance mode is enabled.
     *
     * @var array<int, string>
     */
  public function handle($request, Closure $next)
{
    if (file_exists(storage_path('maintenance'))) {
        return response()->view('maintenance', [], 503);
    }

    return $next($request);
}
}
