<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Traits\CommonFunctionsTrait;
use \App\Models\User;
use \App\Models\ComingSoon;
use \App\Models\ProductQuestion;
use \App\Models\Product;
use \App\Models\State;
use \App\Models\City;
use \App\Models\Cart;
use \App\Models\Dc;
use \App\Models\Category;
use \App\Models\Subcategory;
use \App\Models\Fabric;
use \App\Models\Color;
use \App\Models\Size;
use App\Helper;

use \App\Models\Banner;
use \App\Models\UserAddress;

use \App\Models\Coupon;
use \App\Models\Review;
use \App\Models\Slider;
use \App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportDc;
use App\Exports\ExportDc;
use DB;
use Illuminate\Support\Str;
use Auth;
use \App\Mail\SendPdfMail;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
 use Mail;
 use App\Exports\ExportPartner;
use App\Exports\ExportVendor;
use App\Exports\ExportLearningModule;
use App\Exports\ExportUser;
use App\Exports\ExportPurchasedCourse;
use Validator;
use Illuminate\Support\Facades\Log;

class WebsiteController extends Controller
{
    use CommonFunctionsTrait;
    
 
            
  
   
  public function home(){
    try {
        $products = Product::join('product_sizes', 'products.id', '=', 'product_sizes.product_id')
            ->where('products.status', 1)
            ->select('products.id', 'products.name', 'products.front_image', 'products.hover_image', DB::raw('MIN(product_sizes.sell_price) as sell_price'))
            ->groupBy('products.id')
            ->orderBy('products.created_at', 'desc')
            ->take(10)
            ->get();

             foreach ($products as $product) {
            $productWithRating = Product::leftJoin('reviews', 'products.id', '=', 'reviews.product_id')
                ->where('products.id', $product->id)
                ->where('products.status', 1)
                ->where('reviews.status', 1)
                ->selectRaw('AVG(reviews.rating) as averageRating, COUNT(reviews.id) as totalReviews')
                ->first();
                
            $product->averageRating = $productWithRating ? $productWithRating->averageRating : 0;
            $product->totalReviews = $productWithRating ? $productWithRating->totalReviews : 0;
        }
        
         $data = Review::leftJoin('products','products.id','=','reviews.product_id')
                  ->leftJoin('users','users.id','=','reviews.user_id')
                  ->where('reviews.status', 1)
                  ->select('reviews.*','products.name as product_name','users.name as user_name','users.lname as user_lname','users.address as user_address') 
                  ->latest()
                  ->get();



        return view('front.index', compact('products','data'));
    } catch (\Exception $ex) {
        dd($ex->getMessage());
    }
}


public function shopListing(Request $request, $cat, $subcat = null) {
    try {
        $data = $request->all();
        $category = Category::where('slug', $cat)->first();
        $subcategory = null;

        if ($subcat) {
            $subcategory = Subcategory::where('slug', $subcat)->first();
        }

        $categoryBanner = Banner::where('slug', $cat)->first();

        $colors = $request->input('colors', []);
        $selectedColors = collect($colors);

        $sizes = $request->input('sizes', []);
        $selectedSizes = collect($sizes);

        // $products = Product::where('products.status', 1)
        //     ->leftJoin('product_sizes', 'product_sizes.product_id', '=', 'products.id')
        //     ->select('products.id', 'products.name', 'products.front_image', 'products.hover_image', DB::raw('MIN(product_sizes.sell_price) as sell_price'));
        
         $products = Product::where('products.status', 1)
            ->leftJoin('product_sizes', 'product_sizes.product_id', '=', 'products.id')
             ->leftJoin('reviews', function ($join) {
        $join->on('products.id', '=', 'reviews.product_id')
             ->where('reviews.status', 1); // Filter reviews with status 1
    })
            ->select('products.id', 'products.name', 'products.front_image', 'products.hover_image', DB::raw('MIN(product_sizes.sell_price) as sell_price'), DB::raw('AVG(reviews.rating) as averageRating')) // Include averageRating
            ->groupBy('products.id', 'products.name', 'products.front_image', 'products.hover_image'); // Group by all selected columns

 foreach ($products as $product) {
            $product->averageRating = $product->averageRating ?? 0; // Default value if null
            $product->totalReviews = $product->reviews()->count(); // Get total reviews
        }


        if ($category) {
            $products = $products->where('category_id', $category->id);
        }

        if ($subcategory) {
            $products = $products->where('sub_category_id', $subcategory->id);
        }

        if (!empty($request->search) && isset($request->search)) {
            $searchTerm = $request->search;

            $products = $products->where('name', 'LIKE', '%' . $searchTerm . '%')->orWhere('description', 'LIKE', '%' . $searchTerm . '%');
        }

        $minPrice = 0;
        $maxPrice = 20000;

        if (!empty($request->filter_by_price) && isset($request->filter_by_price)) {
            $prices = explode(';', $request->filter_by_price);
            $minPrice = $prices[0];
            $maxPrice = $prices[1];

            $products = $products->whereBetween('product_sizes.price', [$minPrice, $maxPrice]);
        }

        if (!empty($request->sizes) && isset($request->sizes)) {
            $products = $products->whereHas('sizes', function ($query) use ($sizes) {
                $query->whereIn('size_id', $sizes);
            });
        }

        if (isset($request->colors) && !empty($request->colors)) {
            $products = $products->whereIn('color_id', $colors);
        }

        if (!empty($request->sort_by) && isset($request->sort_by)) {
            if ($request->sort_by == 'default') {
                $products = $products->orderBy('products.id', 'desc');
            }

            if ($request->sort_by == 'popularity') {
                $products = $products->orderBy('products.id', 'asc');
            }

            if ($request->sort_by == 'rating') {
                $products = $products->orderBy('products.average_rating', 'asc');
            }

            if ($request->sort_by == 'latest') {
                $products = $products->orderBy('products.is_new', 'desc');
            }

            if ($request->sort_by == 'low-to-high') {
                $products = $products->orderBy('sell_price', 'asc');
            }

            if ($request->sort_by == 'high-to-low') {
                $products = $products->orderBy('sell_price', 'desc');
            }
        }

        $sortOrder = $request->sort_by;
        $products = $products->groupBy("products.id", 'products.name', 'products.description')->get();

        $filter_search = $request->search ?? Null;

        if ($filter_search) {
            $request->session()->push('searches', $filter_search);
        }

        $filter_cat = $cat;
        $filter_category = $subcategory ? $subcategory->id : null;
        $filter_sort_by = $request->sortby ?? Null;

        $filter_price_range = $request->price ?? Null;
        $output = explode("-", $filter_price_range);
        $filter_price_range_start = $request->min_price;
        $filter_price_range_end = $request->max_price;
        $filter_brand = $request->product_type ?? Null;
        $filter_color = $request->color ?? Null;
        $filter_size = $request->size ?? Null;
        $filter_rating = $request->rating ?? Null;

       if ($cat === 'Serving') {
    // Replace this with the actual category ID for "Serving Products"
    $servingProductsCategoryId = Category::where('slug', 'Serving')->value('id');
    $products = $products->where('category_id', $servingProductsCategoryId);
}

 if ($cat === 'Cooking Wares') {
    // Replace this with the actual category ID for "Serving Products"
    $cookingwaresProductsCategoryId = Category::where('slug', 'Cooking Wares')->value('id');
    $products = $products->where('category_id', $cookingwaresProductsCategoryId);
}

 if ($cat === 'Antique Wall Hanging') {
    // Replace this with the actual category ID for "Serving Products"
    $antiquewallhangingProductsCategoryId = Category::where('slug', 'Antique Wall Hanging')->value('id');
    $products = $products->where('category_id', $antiquewallhangingProductsCategoryId);
}
        $category = Category::where('status', '1')->get();
        $colors = Color::where('status', '1')->get();
        $sizes = Size::where('status', '1')->get();

        return view('front.shop.listing', compact('category', 'products', 'selectedColors', 'sortOrder', 'selectedSizes', 'filter_size', 'filter_color', 'filter_price_range', 'minPrice', 'maxPrice', 'filter_price_range_start', 'filter_price_range_end', 'filter_sort_by', 'filter_category', 'cat', 'categoryBanner', 'filter_brand', 'subcategory', 'colors', 'sizes'));
    } catch (\Exception $ex) {
        dd($ex->getMessage() . '-' . $ex->getLine());
    }
}

    

// auto search product
     public function autocompleteSearch(Request $request)
    {
          $query = $request->get('query');
          $filterResult = Product::where('name', 'LIKE', '%'. $query. '%')->get();

            $data = array();
        if(count($filterResult) > 0){
        foreach ($filterResult as $result)
            {
                $data[] = $result->name;
            }
           
                return response()->json($data);
            }else{
                $data = "No_data";
               
                return response()->json($data); 
            }
          
    } 
    
    
  
    
    
//     public function productsdetails($id){
//     try {
//         $product = Product::where('products.id', $id)
//             ->leftJoin('categories', 'categories.id', '=', 'products.category_id')
//             ->where('products.status', '1')
//             ->select('categories.name as cat_name', 'products.*')
//             ->first();

//         // Determine sizes based on category and gender
//         if ($product->cat_id == 1) {
//             $sizes = $product->gender == 'female' ? [8,9,10,11,12,13,14,15,16,17,18,19] : [11,12,13,14,15,16,17,18,19,20,21,22,23];
//         } elseif ($product->cat_id == 3) {    
//             $sizes = [14,15,16,17,18,19,20];
//         } elseif ($product->cat_id == 4) {
//             $sizes = [2.0,2.2,2.4,2.6,2.8,2.10];
//         } else {
//             $sizes = [];
//         }

//         // Retrieve related products
//         $relatedProduct = Product::where('id', '!=', $product->id)
//             ->where('category_id', $product->category_id)
//             ->inRandomOrder()->take(8)->get();
        
//         // Check if the user is logged in
//         if (Auth::check()) {
//             $userId = Auth::id();
//             $cartIdentifier = null; // Reset $cartIdentifier to null if the user is logged in
//         } else {
//             $cartIdentifier = request()->cookie('cart_identifier');
//             if (!$cartIdentifier) {
//                 $cartIdentifier = Str::uuid()->toString();
//             }
//             $userId = null;
//         }
        
//         // Check if the product is already in the cart for the current user
//         $isInCart = Cart::where('user_id', $userId)
//             ->where('product_id', $id)
//             ->exists();
            
//     //   $reviews = Review::where('product_id', $id)->get();

//         return view('front.shop.product-details', compact('product', 'relatedProduct', 'sizes', 'isInCart'));

//     } catch(\Exception $ex) {
//         dd($ex->getMessage());
//     }
// }


public function productsdetails($id)
{
    try {
        $product = Product::leftJoin('categories', 'categories.id', '=', 'products.category_id')
            ->where('products.id', $id)
            ->where('products.status', 1)
            ->select('categories.name as cat_name', 'products.*')
            ->first();

        if (!$product) {
            // Handle the case where the product does not exist
            abort(404);
        }

        // Determine sizes based on category and gender
        if ($product->cat_id == 1) {
            $sizes = $product->gender == 'female' ? [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19] : [11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23];
        } elseif ($product->cat_id == 3) {    
            $sizes = [14, 15, 16, 17, 18, 19, 20];
        } elseif ($product->cat_id == 4) {
            $sizes = [2.0, 2.2, 2.4, 2.6, 2.8, 2.10];
        } else {
            $sizes = [];
        }

        // Retrieve related products
        $relatedProduct = Product::where('id', '!=', $product->id)
            ->where('category_id', $product->category_id)
            ->inRandomOrder()->take(8)->get();
        
        // Check if the user is logged in
        if (Auth::check()) {
            $userId = Auth::id();
            $cartIdentifier = null; // Reset $cartIdentifier to null if the user is logged in
        } else {
            $cartIdentifier = request()->cookie('cart_identifier');
            if (!$cartIdentifier) {
                $cartIdentifier = Str::uuid()->toString();
            }
            $userId = null;
        }
        
        $isInCart = Cart::where('user_id', $userId)
            ->where('product_id', $id)
            ->exists();
        
        $productWithRating = Product::leftJoin('reviews', function ($join) {
        $join->on('products.id', '=', 'reviews.product_id')
             ->where('reviews.status', 1);
        })
            ->where('products.id', $id)
            ->where('products.status', 1)
            ->selectRaw('products.*, AVG(reviews.rating) as averageRating, COUNT(reviews.id) as totalReviews')
            ->groupBy('products.id')
            ->first();

        // Extract the average rating and total reviews from the joined result
        $averageRating = $productWithRating ? $productWithRating->averageRating : 0;
        $totalReviews = $productWithRating ? $productWithRating->totalReviews : 0;

        return view('front.shop.product-details', compact('product', 'relatedProduct', 'sizes', 'isInCart', 'averageRating', 'totalReviews'));

    } catch (\Exception $ex) {
        dd($ex->getMessage());
    }
}



    
     public function aboutUs(){
        try {
          return view('front.about-us');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

// Get Contact Us 
     public function contactUs(){
        try {

          return view('front.contact_us');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
     // Get privacy and policy  
     public function PrivacyAndPolicy(){
        try {
          return view('front.privacy-policy');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

// Get terms and conditions   
     public function TermsAndCondition(){
        try {
          return view('front.terms-condition');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
// Get return policy    
     public function ReturnPolicy(){
        try {
          return view('front.return-policy');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
      public function RefundPolicy(){
        try {
          return view('front.refund-policy');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    

    
      public function Faq(){
        try {
          return view('front.faq');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function gitCard(){
        try {
          return view('front.gift_card');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
      public function cookieSetting(){
        try {
          return view('front.cookie_setting');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
      public function customerService(){
        try {
          return view('front.customer_service');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
        public function registrationAndLogin(){
        try {
          return view('front.registration_and_login');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
        public function ManagingMyProfile(){
        try {
          return view('front.managing_my_profile');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
        public function myFavourites(){
        try {
          return view('front.my_favourites');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
        public function itemsAvalibility(){
        try {
          return view('front.items_availability');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function wahtsMySize(){
        try {
          return view('front.whats_my_size');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function compositionAndCare(){
        try {
          return view('front.composition_and_care');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function paymentMethod(){
        try {
          return view('front.payment_method');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function paymentSecurity(){
        try {
          return view('front.payment_security');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function invoices(){
        try {
          return view('front.invoices');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function orderStatus(){
        try {
          return view('front.order_Status');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function changeOrCancel(){
        try {
          return view('front.change_or_cancel');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function issueWithMyOrder(){
        try {
          return view('front.issue_with_my_order');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function exchange(){
        try {
          return view('front.exchange');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
          public function emailVerificationPolicy(){
        try {
          return view('front.email_verification_policy');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
    
    public function registrationForm(){
       
        return view('front.register');
    }


   public function userLogout(Request $request) {
                    Auth::logout();
              return redirect()->route('homePage');
            }
   
 // register user 
    
    public function register(Request $request)
{
    $validator = Validator::make($request->all(), [
        'name' => 'required',
        'email' => 'required|email|unique:users',
        'phone_number' => 'required|unique:users',
        'password' => 'min:6|required', 
    ], [
        'name.required' => 'Enter your name.',
        'email.required' => 'Enter your email.',
        'phone_number.required' => 'Enter your phone number.',
        'password.required' => 'Enter password.',
    ]);

    if ($validator->passes()) {
        DB::beginTransaction();
        try {
            $user = new User();
            $user->name = $request->name;
            $user->lname = $request->lname;
            $user->email = $request->email;
            $user->phone_number = $request->phone_number;
            $user->type = 0;
            $user->password = Hash::make($request->password);
            $user->save();

            // Associate cart items with the registered user if available
            $cartIdentifier = $request->cookie('cart_identifier');
            if ($cartIdentifier) {
                $userId = $user->id;
                $tempCartItems = Cart::where('random_id', $cartIdentifier)->get();
                foreach ($tempCartItems as $tempCartItem) {
                    $tempCartItem->user_id = $userId;
                    $tempCartItem->random_id = null; // Clear the random_id
                    $tempCartItem->save();
                }
            }

            Auth::login($user);
            DB::commit();
            return response()->json([
                'status' => true,
                'code' => 200,
                'useremail' => $user->email,
            ]);
        } catch(\Exception $ex) {
            DB::rollback();
            return response()->json([
                'status' => false,
                'code' => 400,
                'msgText' => $ex->getMessage() . '-' . $ex->getLine(),
            ]);
        }
    } else {
        return response()->json([
            'status' => false,
            'code' => 422,
            'errors' => $validator->errors(),
        ]);
    }
}

    
    
        
    public function guestSignUp(){
       
        return view('front.guest_sign_up');
    }



 public function loginForm(){
       
        return view('front.login');
    }

  public function login(Request $request)
    {
        //dd($request->all());
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required|min:6',
        ]);
        if ($validator->passes()) {
            DB::beginTransaction();
            try {
                $credentials = [
                    'email' => $request->email,
                    'password' => $request->password,
                    'type' => 0,
                ];
                if (Auth::attempt($credentials)) {
                    $cartIdentifier = $request->cookie('cart_identifier');
                    if ($cartIdentifier) {
                        $cartItems = Cart::where('random_id', $cartIdentifier)
                            ->get();
                            if(!empty($cartItems)){
                                foreach($cartItems as $cartItem){
                                    $data = Cart::where('id',$cartItem->id)->first();
                                    $chkAlreadyAdded = Cart::where('product_id',$cartItem->product_id)->where('user_id',Auth::user()->id)->first();
                                    if(!empty($chkAlreadyAdded)){
                                         $chkAlreadyAdded->quantity = $chkAlreadyAdded->quantity + 1;
                                        $chkAlreadyAdded->save();
                                        $cartItem->delete();
                                    }else{
                                         $data->user_id = Auth::user()->id;
                                        $data->random_id = "";
                                        $data->save();
                                    }
                                   
                                    //echo '<pre/>';print_r($data);die;
                                }
                            }
                    }
                      DB::commit();
                    $user = Auth::user();
                    if($user->status == 1){

                    return response()->json([
                        'status' => true,
                    ]);
                        
                    }else{

                         return response()->json([

                        'status' => false,
                        'code' => 302,
                        'errors' => [
                            'email' => [
                                'Oops! looks like your email is deactivated,please contact customer support.'
                            ]
                        ]
                    ]);

                    }
                    
                } else {
                    DB::rollback();
                    return response()->json([
                        'status' => false,
                        'code' => 422,
                        'errors' => [
                            'email' => [
                                'User Not Register Or Invalid Credential'
                            ]
                        ]
                    ]);
                }
            } catch(\Exception $ex) {
                DB::rollback();
                return response()->json([
                    'status' => false,
                    'code' => 400,
                    'msgText' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            DB::rollback();
            return response()->json([
                'status' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }
    
    
        public function notifyMe(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required',
        ],[
             'email.required' => 'Enter your email.'

        ]);
        if ($validator->passes()) {
            DB::beginTransaction();
            try {
            
                
                $user = new ComingSoon();
                $user->email = $request->email;
                $user->name = $request->name;
                $user->phone_number = $request->phone_number;
                $user->product_id = $request->product_id;
                $user->save();
              //Auth::login($user);
             DB::commit();
                            return response()->json([
                    'success' => true,
                    'message' => 'Waitlist Joined Successfully.'
                ]);
            } catch(\Exception $ex) {
                DB::rollback();
                return response()->json([
                    'status' => false,
                    'code' => 400,
                    'msgText' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            DB::rollback();
            return response()->json([
                'status' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }
    
     public function getSizeChart(Request $request){
        $getProductData = Product::where('id',$request->id)->first();
        return view('front.shop.size_chart',compact('getProductData'));
    }
    
    
    public function SaveNewGuestAddress(Request $request)
    {
          $cartIdentifier = $request->cookie('cart_identifier');
                 //echo $cartIdentifier;die;
                   if (empty($cartIdentifier)) {
                              return response()->json([
                            'success' => false,
                            'code' => 500,
                        ]);
                     
                    }else{
                       
                        $cartItems = Cart::where('random_id', $cartIdentifier)
                            ->get();
                            // echo '<pre/>';print_r($cartItems);die;
                            if(count($cartItems) == 0){
                                  return response()->json([
                            'success' => false,
                            'code' => 500,
                        ]);   
                        
                            }
                    }
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'mobile' => 'required',
            'country' => 'required',
            'state' => 'required',
            'town_city' => 'required',
            'pin_code' => 'required',
            'address' => 'required',
            'address_type' => 'required',
        ]);
        if ($validator->passes()) {
            try {
               
                  if (empty($cartIdentifier)) {
                              return response()->json([
                            'success' => false,
                            'code' => 500,
                        ]);
                     
                    }else{
                       
                        $cartItems = Cart::where('random_id', $cartIdentifier)
                            ->get();
                            // echo '<pre/>';print_r($cartItems);die;
                            if(count($cartItems) == 0){
                                  return response()->json([
                            'success' => false,
                            'code' => 500,
                        ]);   
                        
                            }
                    }
                 $data = new UserAddress();
                if(!empty($request->email)){
                    $getUserExist = User::where('email',$request->email)->first();
                    if(empty($getUserExist)){
                         $user = new User();
                        $user->name = $request->name;
                        $user->email = $request->email;
                        $user->phone_number = $request->mobile;
                        $user->type = 0;
                        $user->password = Hash::make(123456789);
                        $user->save();
                        $data->user_id = $user->id;
              
                 Auth::login($user);
                 
                    }else{
                        
                        $data->user_id = $getUserExist->id;
               $default_address = UserAddress::where('user_id',$getUserExist->id)->where('default_address',1)->first();
                 if(!empty($default_address)){
                     UserAddress::where('id', $default_address->id)->update(['default_address' => 0]);
                 }
                 Auth::login($getUserExist);
                 
                    }
                    
                }
                
                 
                  $cartItems = Cart::where('random_id', $cartIdentifier)
                            ->get();
                
                 if(!empty($cartItems)){
                    foreach($cartItems as $cartItem){
                        $dataC = Cart::where('id',$cartItem->id)->first();
                        $dataC->user_id = Auth::user()->id;
                        $dataC->random_id = "";
                        $dataC->save();
                    }
                 }
                
                
                $data->name = $request->name;
                $data->email = $request->email;
                $data->mobile = $request->mobile;
                $data->address_type = $request->address_type;
                $data->country_id = $request->country;
                $data->state_id = $request->state;
                $data->city_id = $request->town_city;
                $data->pin_code = $request->pin_code;
                $data->address = $request->address;
                $data->locality = $request->locality;
                  $data->default_address = 1;
               $data->save();
                $this->sendAddressDataToSales($data);
                return response()->json([
                    'success' => true,
                    'message' => 'Address added.'
                ]);
            } catch(\Exception $ex) {
                return response()->json([
                    'success' => false,
                    'code' => 400,
                    'msgText' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            return response()->json([
                'success' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }

}