<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Traits\CommonFunctionsTrait;
use Illuminate\Http\Request;

use Auth;
use App\Models\User;
use Session;
use Illuminate\Support\Facades\Validator;
use Hash;
use DB;

use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\UserAddress;
use App\Models\HelpQueries;

use App\Models\Wishlist;
use Carbon\Carbon; 
use App\Models\Property;
use Mail;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use PDF;
use App\Mail\UserHelpEmail;
use App\Mail\AdminHelpEmail;
use App\Mail\OrderEmail;

class UserController extends Controller
{
use CommonFunctionsTrait;

//userdashboard 

 public function userDashboard() {
        try {
           
             $customer = Auth::user();
            $recent_orders = Order::latest()->where('user_id',$customer->id)->take(5)->get();
            // dd( $recent_orders );
            $customer_address = UserAddress::where('user_id',$customer->id)->where('default_address',1)->first();
          return view('front.customer.dashboard',compact('customer','recent_orders','customer_address'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

// userAccount
 public function myAccount()
    {
        try {
          
           $user = Auth::user();
            return view('front.customer.my-account',compact('user'));
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

// update my account 
       public function updateMyAccount(Request $request)
    {
     
           $request->validate([
            'name' => 'required',
            'image' => 'sometimes|mimes:jpeg,jpg,png,gif|max:2048',
            'email' => [ "required",Rule::unique('users')->ignore(Auth::user()->id)],
            'phone_number' => [ "required",Rule::unique('users')->ignore(Auth::user()->id)],
        ]);
            try {
                $image = $request->file('image');
                $user = Auth::user();

               
                $user->name = $request->name;
                 $user->email = $request->email;
                $user->phone_number = $request->phone_number;
              
     $image = $request->file('image');
        if(isset($image) && !empty($image)){
            $imageName = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/user');
            $image->move($destinationPath, $imageName);
            $imagePath = 'public/uploads/user/'.$imageName;
            $user->image=$imagePath;
        }
               if( $user->save()){
                     DB::commit();
                     
                    return redirect()->back()->with('success','Account Updated successfully.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
       
    }

// change password 
     public function changeMyPassword()
    {
        try {
          
           $user = Auth::user();
            return view('front.customer.change-password',compact('user'));
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

//   public function updateMyPassword(Request $request){

//         $request->validate([
//           'old_password'  =>  'required',
//             'new_password' => 'required|confirmed|min:6',
//             'new_password_confirmation' => 'required|min:6',
//         ]);

//         $user = User::where('id',Auth::user()->id)->first();
//         if (isset($user->id)) {

//       // check if current password matched

//       if (Hash::check($request->old_password, $user->password)) { 
//           $user->password = Hash::make($request->new_password);

//             if($user->save()){
//             return back()->with("success", "password changed successfully.");
//                 } else{
//                      return back()->with("error", "failed to Change Password,Try Again....");
//                       }

//                 }else{
//             return back()->with("error", "password doesn't match,Try Again....");
//          }

//     }else{
//         return back()->bacK()->with('error','Something went wrong try later');
//          }

// }

public function updateMyPassword(Request $request)
{
    $validator = Validator::make($request->all(), [
        'old_password' => [
            'required',
            function ($attribute, $value, $fail) {
                if (!Hash::check($value, Auth::user()->password)) {
                    $fail('The old password is incorrect.');
                }
            },
        ],
        'new_password' => 'required|confirmed|min:6',
        'new_password_confirmation' => 'required|min:6',
    ]);

    if ($validator->fails()) {
        return back()->withErrors($validator)->withInput();
    }

    $user = Auth::user();
    $user->password = Hash::make($request->new_password);

    if ($user->save()) {
        return back()->with("success", "Password changed successfully.");
    } else {
        return back()->with("error", "Failed to change password. Please try again.");
    }
}
// my orders
 
     public function myOrders() {
        try {
      
            $customer = Auth::user();
            $orders = Order::with('orderDetails.product', 'user')->leftJoin('users','users.id','=','orders.user_id')->where('user_id',$customer->id)->select('orders.*','users.name as user_nsme')->latest()->get();
         
            return view('front.customer.my-orders')->with([
                'customer' => $customer,
                'orders' => $orders,
              
            ]);
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    



     // get order  details
      public function orderDetails($order_id) {
        try {
      
          $orders = Order::where('id',$order_id)->with('order_details')->latest()->first();
            $Address = UserAddress::where('id',$orders->address_id)->first();
            return view('front.customer.order-details')->with([
               'orders' => $orders,
               'customer_address' => $Address,
            ]);
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

// my wishlist
      public function myWishlist()
    {
        try {
           
            $customer = Auth::user();
            $wishlists = Wishlist::where('user_id',$customer->id)->get();
            return view('front.customer.my-wishlist')->with([
                'customer' => $customer,
                'wishlists' => $wishlists,
            ]);
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

    public function DownloadInvoice($order_id)
    {
        try {
            $user = Auth::user();

            $order = Order::where('id',$order_id)->where('user_id',$user->id)->first();
      
           //dd($order);
           $pdf = PDF::loadView('front.user.invoice',compact('order'));
           
           dd($order);
             return $pdf->download($order->payment_id.'.pdf');
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }


  // myaddress book 

  public function myAddressBook()
    {
        try {
          
            $customer = Auth::user();
            $customer_addresses = UserAddress::latest()->where('user_id',$customer->id)->get();
            return view('front.customer.address-book.my-address-book')->with([
                'customer' => $customer,
                'customer_addresses' => $customer_addresses,
            ]);
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

public function addNewAddress()
    {
      try {
          
            return view('front.customer.address-book.add-new-address');
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    public function saveNewCustomerAddress(Request $request)
{
    $validator = Validator::make($request->all(), [
        'name' => 'required',
        'mobile' => 'required',
        'country' => 'required',
        'state' => 'required',
        'town_city' => 'required',
        'pin_code' => 'required',
        'address' => 'required',
        'address_type' => 'required',
    ]);

    if ($validator->passes()) {
        try {
            $data = new UserAddress();
            $customer = Auth::user();
            $defaultAddress = UserAddress::where('user_id', Auth::user()->id)->where('default_address', 1)->first();

            if (!empty($defaultAddress)) {
                UserAddress::where('id', $defaultAddress->id)->update(['default_address' => 0]);
            } else {
                $data->default_address = 1;
            }

            $data->user_id = Auth::user()->id;
            $data->name = $request->name;
            $data->mobile = $request->mobile;
            $data->address_type = $request->address_type;
            $data->country_id = $request->country;
            $data->state_id = $request->state;
            $data->city_id = $request->town_city;
            $data->pin_code = $request->pin_code;
            $data->address = $request->address;
            $data->locality = $request->locality;
            $data->save();
            
            return redirect()->route('myAddressBook')->with('success', 'Address added successfully.');
        } catch (\Exception $ex) {
            return response()->json([
                'success' => false,
                'code' => 400,
                'msgText' => $ex->getMessage() . '-' . $ex->getLine(),
            ]);
        }
    } else {
        return redirect()->back()->withErrors($validator)->withInput();
    }
}





    // edit my address book

     public function editMyAddressBook($id)
    {
        try {
            $customer = Auth::user();
            $customer_address = UserAddress::where('id',$id)->where('user_id',$customer->id)->firstOrFail();

             return view('front.customer.address-book.edit-address-book',compact('customer_address'));
            
        } catch(\Exception $ex) {
            return response()->json([
                "success" => false,
                'msgText' => $ex->getMessage(),
            ]);
        }
    }


// update my adddress book 
    // public function updateMyAddressBook(Request $request,$id)
    // {
    //     $validator = Validator::make($request->all(), [
    //         'name' => 'required',
    //         'mobile' => 'required',
    //         'country' => 'required',
    //         'state' => 'required',
    //         'town_city' => 'required',
    //         'pin_code' => 'required',
    //         'address' => 'required',
    //         'address_type' => 'required',
    //     ]);
    //     if ($validator->passes()) {
    //         try {
    //             $customer = Auth::user();
    //             $data = UserAddress::where('id',$id)->where('user_id',$customer->id)->firstOrFail();
    //               $data->user_id = Auth::user()->id;
              
    //             $data->name = $request->name;
    //             $data->mobile = $request->mobile;
    //             $data->address_type = $request->address_type;
    //             $data->country_id = $request->country;
    //             $data->state_id = $request->state;
    //             $data->city_id = $request->town_city;
    //             $data->pin_code = $request->pin_code;
    //             $data->address = $request->address;
    //             $data->locality = $request->locality;
    //           $data->save();
    //             // $this->sendAddressDataToSales($data);
    //             return response()->json([
    //                 'success' => true,
    //                 'message' => "Address updated"
    //             ]);
    //         } catch(\Exception $ex) {
    //             return response()->json([
    //                 'success' => false,
    //                 'code' => 400,
    //                 'msgText' => $ex->getMessage() .'-'.$ex->getLine(),
    //             ]);
    //         }
    //     } else {
    //         return response()->json([
    //             'success' => false,
    //             'code' => 422,
    //             'errors' => $validator->errors(),
    //         ]);
    //     }
    // }

public function updateMyAddressBook(Request $request, $id)
{
    $validator = Validator::make($request->all(), [
        'name' => 'required',
        'mobile' => 'required',
        'country' => 'required',
        'state' => 'required',
        'town_city' => 'required',
        'pin_code' => 'required',
        'address' => 'required',
        'address_type' => 'required',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    try {
        $customer = Auth::user();
        $data = UserAddress::where('id', $id)->where('user_id', $customer->id)->firstOrFail();

        $data->user_id = Auth::user()->id;
        $data->name = $request->name;
        $data->mobile = $request->mobile;
        $data->address_type = $request->address_type;
        $data->country_id = $request->country;
        $data->state_id = $request->state;
        $data->city_id = $request->town_city;
        $data->pin_code = $request->pin_code;
        $data->address = $request->address;
        $data->locality = $request->locality;
        $data->save();

        return redirect()->route('myAddressBook')->with('success', 'Address updated successfully.');
    } catch (\Exception $ex) {
        return redirect()->back()->with('error', 'Failed to update address. ' . $ex->getMessage());
    }
}


// delete my address book
  public function DeleteMyAddressBook($id)
    {
        try {
            $customer = Auth::user();
            UserAddress::where('id',$id)->where('user_id',$customer->id)->delete();
          return redirect()->back()->with('success','Address deleted');
        } catch(\Exception $ex) {
            return response()->json([
                'success' => false,
                'msgText' => $ex->getMessage(),
            ]);
        }
    }  

// user help section
 public function HelpQuerie()
    {
        try {
          
        $help = HelpQueries::where('user_id',Auth::user()->id)->latest()->get();
            return view('front.user.help',compact('help'));
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

    public function AskForHelp(Request $request)
   {
        //dd($request->all());
       
        $validator = Validator::make($request->all(),[
            'name' => 'required',
            'email' =>'required',
            'message' => 'required',
        ],[
            'name.required' => 'Enter your name.',
            'email.required' => 'Enter your email-id.',
            'message.required' => 'Please type your question.'


        ]);
  if ($validator->passes()) {
            DB::beginTransaction();
            try {
                
                $user = Auth::user();

                while(true) {
                    $ticket_no = 'HELP'.random_int(100000,999999);
                    if (!HelpQueries::where('ticket_no',$ticket_no)->exists()) {
                        break;
                    }
                }
                $Ques = New HelpQueries;
                $Ques->ticket_no =  $ticket_no;
                $Ques->user_id =  $user->id;
                $Ques->name = $request->name;
                $Ques->email = $request->email;
                $Ques->message = $request->message;
                $Ques->save();
                
                 // if success send email notification to user and admin
                
                // send notification admin
                        $adminEmail = "91darklord@gmail.com"; 
                        

                // send notification to user 
                        $userData['title'] = "Help / Complain Email";
                        $userData['subject'] = 'Help / Complain Email';
                        $userData['name'] = $Ques->name;
                        $userData['email'] = $Ques->email;
                        $userData['ticket_no'] = $Ques->ticket_no;
                        $userData['message'] = $Ques->message;
                     Mail::to(Auth::user()->email)->send(new UserHelpEmail($userData));
                     Mail::to($adminEmail)->send(new AdminHelpEmail($userData));
                               
                // end email

                     DB::commit();
                    return response()->json([
                    'status' => true,
                    'code' => 200,
                    'message'=>'You have successfully raised a question for help, We will back to you shortly.',
                ]); 
            
            } catch(\Exception $ex) {
                  DB::rollback();
                return response()->json([
                    'status' => false,
                    'code' => 400,
                    'errors' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        }else {
            DB::rollback();
            return response()->json([
                'status' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
       
    }


 public function recentBookingSession()
    {
        try {
             $today = date('Y-m-d');
            $user = Auth::user();
           $recentBooking = UserBookedSlot::where('user_id',$user->id)
                            ->where('event_date','>=',$today)
                            ->where('booking_status','booked')
                            ->orderBy('id','DESC')
                            ->get();

            return view('front.user.recent-booking',compact('recentBooking','today'));
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }

// Assigned properties
 public function AssignedProperties()
    {
        try {
            
            $user = Auth::user();
            $assignedPropertyIds =explode(",", $user->assigned_property_id);

            return view('front.user.assigned-property',compact('assignedPropertyIds'));
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
  
}