<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Razorpay\Api\Api;
use \App\Models\User;
use \App\Models\Booking;
use \App\Models\Product;
use \App\Models\Coupon;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Config;


class RazorpayController extends Controller
{
    public function initiatePayment(Request $request)
    {
        //echo 66;die;
        $api_key = 'rzp_test_aRMWSroqAFi9D4'; // Replace with your actual Razorpay API key
        $api_secret = 'QZOhlVb9Fwyvinbx380sre6m'; // Replace with your actual Razorpay API secret
        $api = new Api($api_key, $api_secret);

        $amount = $request->amount;
        $currency = 'INR';
        $receipt_id = uniqid();
        $notes = [
            'user_id' => $request->user_id, // Replace with the user ID of the logged-in user
            'mobile' => $request->mobile, // Replace with the mobile number of the logged-in user
        ];

        $order = $api->order->create([
            'amount' => $amount,
            'currency' => $currency,
            'receipt' => $receipt_id,
            'notes' => $notes,
        ]);

        $response = [
            'key' => $api_key,
            'amount' => $amount,
            'name' => 'Your App Name',
            'description' => 'Your payment description',
            'order_id' => $order->id,
            'user_id' => $request->user_id, // Replace with the user ID of the logged-in user
            'mobile' => $request->mobile, // Replace with the mobile number of the logged-in user
        ];

        return response()->json($response);
    }
    
    
    
    public function checkout(Request $request)
    {
       // echo $request->amount;die;
        
        $api_key = 'rzp_test_aRMWSroqAFi9D4';
        $api_secret = 'QZOhlVb9Fwyvinbx380sre6m';
        
        $api = new Api($api_key, $api_secret);
         $notes = [
        'course_id' => $request->course_id,
        'coupon_id' => $request->coupon_id,
        'user_id'=>$request->user_id
    ];
        $order = $api->order->create([
            'amount' => $request->amount *100,
            'currency' => 'INR',
            'payment_capture' => 1,
            'notes' => $notes,
        ]);
        $userDetail = User::where('id',$request->user_id)->first();
        $courseId = $request->course_id;
        $userId = $request->user_id;
        $couponId = $request->course_id;
       // echo '<pre/>';print_r($order);die;
        return view('checkout', compact('order','userDetail','courseId','userId','couponId'));
    }
    
    public function payment(Request $request)
    {
        $api_key = 'rzp_test_aRMWSroqAFi9D4';
        $api_secret = 'QZOhlVb9Fwyvinbx380sre6m';
        // $notes = json_decode($request->input('notes'), true); // Decode the JSON string
    
    // echo '<pre/>';print_r($notes);die;
        $api = new Api($api_key, $api_secret);
        
        $payment = $api->payment->fetch($request->razorpay_payment_id);
        
        //echo '<pre/>';print_r(json_encode($paymentArray));die;
        
        if ($payment->status == 'captured') {
            $data = new Booking();
       
            $data->user_id = $payment->notes->user_id;
            $data->course_id = $payment->notes->course_id;
            $getCourseCount = Product::where('id',$payment->notes->course_id)->select('re_attempt')->first();
            if($getCourseCount){
                if($getCourseCount->re_attempt > 0){
                    $data->total_attempt = $getCourseCount->re_attempt;
                }else{
                    $data->total_attempt = 1;
                }
            }
            $data->coupon_id = $payment->notes->coupon_id;
            if($payment->notes->coupon_id != 0){
                Coupon::where('id',$payment->notes->course_id)->update(array(
                             'is_active'=>0,
                ));
            }
            $data->email = $payment->email;
            $userDetail = User::where('id',$payment->notes->user_id)->first();
            $data->user_name = $userDetail->name;
            $data->order_id = $payment->order_id;
            $data->amount = $payment->amount/100;
            $paymentArray = $payment->toArray();
            $data->payment_history = json_encode($paymentArray);
            $data->save();
            return view('success');
           // return response()->json($payment);
        } else {
            // Payment failed
            //echo 11111;die;
            return view('failure');
        }
    }
    
    
      public function index()
    {
        return view('payment.index');
    }

    public function processPayment(Request $request)
    {
          $workingKey = 'A00F3809395EA122894A307E4B4AB1B9'; // Replace with your actual working key

        $merchantData = 'M22MCAPKU188P';
        foreach ($request->except('_token') as $key => $value) {
            $merchantData .= $key . '=' . $value . '&';
        }

        // Encrypt the payment parameters
        $encrypted_data = $this->encryptPaymentData($merchantData,$workingKey);
        $accessCode = 'AVZS92KG29CA52SZAC';
      
 // echo '<pre/>';print_r($productionUrl);die;
  return view('payment.iframe', compact('encrypted_data','accessCode'));
    }

    private function encryptPaymentData($plainText,$key)
{
   $key = $this->hextobin(md5($key));
	$initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
	$serializedData = serialize($plainText);
	$openMode = openssl_encrypt($plainText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
	$encryptedText = bin2hex($openMode);
	return $encryptedText;
}


public function decrypt($encryptedText,$key)
{
	$key = $this->hextobin(md5($key));
	$initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
	$encryptedText = $this->hextobin($encryptedText);
	$decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
	return $decryptedText;
}

public function hextobin($hexString) 
 { 
	$length = strlen($hexString); 
	$binString="";   
	$count=0; 
	while($count<$length) 
	{       
	    $subString =substr($hexString,$count,2);           
	    $packedString = pack("H*",$subString); 
	    if ($count==0)
	    {
			$binString=$packedString;
	    } 
	    
	    else 
	    {
			$binString.=$packedString;
	    } 
	    
	    $count+=2; 
	} 
        return $binString; 
  } 
  
    public function paymentSuccess(Request $request)
    {
         error_reporting(0);

        $workingKey = 'A00F3809395EA122894A307E4B4AB1B9'; // Working Key should be provided here.
        $encResponse = $request->input("encResp");
        $rcvdString = $this->decrypt($encResponse, $workingKey);
        $order_status = "";
        $decryptValues = explode('&', $rcvdString);
        $dataSize = sizeof($decryptValues);
        $output = "<center>";

        for ($i = 0; $i < $dataSize; $i++) {
            $information = explode('=', $decryptValues[$i]);
            if ($i == 3) $order_status = $information[1];
        }

        if ($order_status === "Success") {
            $output .= "<br>Thank you for shopping with us. Your credit card has been charged and your transaction is successful. We will be shipping your order to you soon.";
        } else if ($order_status === "Aborted") {
            $output .= "<br>Thank you for shopping with us. We will keep you posted regarding the status of your order through e-mail";
        } else if ($order_status === "Failure") {
            $output .= "<br>Thank you for shopping with us. However, the transaction has been declined.";
        } else {
            $output .= "<br>Security Error. Illegal access detected";
        }

        $output .= "<br><br>";

        $output .= "<table cellspacing=4 cellpadding=4>";
        for ($i = 0; $i < $dataSize; $i++) {
            $information = explode('=', $decryptValues[$i]);
            $output .= '<tr><td>' . $information[0] . '</td><td>' . $information[1] . '</td></tr>';
        }
        $output .= "</table><br>";
        $output .= "</center>";

        return view('payment.response', ['output' => $output]);
    }

    public function paymentFailure(Request $request)
    {
        // Handle payment failure in the test environment
    }
    
    
}