<?php

namespace App\Http\Controllers;

use \App\Models\User;
use \App\Models\Subcategory;
use \App\Models\ProductQuestion;
use \App\Models\Product;
use \App\Models\State;
use \App\Models\City;
use \App\Models\ProductQuestionAnswer;
use \App\Models\Dc;
use \App\Models\Category;
use \App\Models\Fabric;
use \App\Models\Color;
use \App\Models\Size;
use \App\Models\Banner;
use \App\Models\ProductSize;
use \App\Models\Coupon;
use \App\Models\Slider;
use \App\Models\Review;
use \App\Models\Order;
use \App\Models\ComingSoon;
use \App\Models\UserAddress;
use \App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportDc;
use App\Exports\ExportDc;
use DB;
use Illuminate\Support\Str;
use Auth;
use \App\Mail\SendPdfMail;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
 use Mail;
 use App\Exports\ExportPartner;
use App\Exports\ExportVendor;
use App\Exports\ExportLearningModule;
use App\Exports\ExportUser;
use App\Exports\ExportPurchasedCourse;

class AdminController extends Controller
{
      public function __construct()
    {
        $this->middleware('auth');
    }
    
     public function adminlogout(Request $request) {
                    Auth::logout();
              return redirect('/admin/login');
            }
   
   
    
    public function listCategory()
    {  
        try {
           
            $categories = Category::orderBy('sort_order','asc')->get();

          return view('admin.category.index',compact('categories'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
    
    public function addCategory()
    {
        try {
        
          return view('admin.category.create');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
    public function setCurrency(Request $request, $currency)
    {
        // Validate the selected currency
        if ($currency == 'usd' || $currency == 'inr') {
            // Set the selected currency in the session
            $request->session()->put('currency', $currency);
        }

        // Redirect back to the previous page or any other desired page
        return redirect()->back();
    }
  
    public function saveCategory(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|unique:categories',
        ],[
            'name.required' => 'Enter Category Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $category = New Category;
                $category->name = $request->name;
                $category->slug = $slug;
                $image = $request->file('image');
              if(isset($image) && !empty($image)){
                $imageName = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/category');
                $image->move($destinationPath, $imageName);
                $imagePath = 'public/uploads/category/'.$imageName;
                $category->image=$imagePath;
              }

               if(!empty($request->text_on_banner)){
                    $category->text_on_banner = $request->text_on_banner;
                }

               if( $category->save()){
                     DB::commit();      
                    return redirect()->route('category.list')->with('success','Category Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editCategory($id =0 )
    {
         try {
           
            $category = Category::find($id);

          return view('admin.category.edit',compact('category'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateCategory(Request $request,$id = 0)
    {

       $request->validate([
            'name' => 'required|max:255',
            
        ],[
            'name.required' => 'Enter Category Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                
                $category = Category::find($id);
               $category->name = $request->name;
                $image = $request->file('image');
              if(isset($image) && !empty($image)){
                $imageName = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/category');
                $image->move($destinationPath, $imageName);
                $imagePath = 'public/uploads/category/'.$imageName;
                $category->image=$imagePath;
              }
              
              if(!empty($request->text_on_banner)){
                    $category->text_on_banner = $request->text_on_banner;
                }

               
               if( $category->save()){
                     DB::commit();      
                    return redirect()->route('category.list')->with('success','Category Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    //  public function viewUserDetails($id) {
    //     $user = User::find($id);
    
    //     if (!$user) {
    //         return redirect()->route('admin.users.index')->with('error', 'User not found');
    //     }

    
    //     return view('admin.user.view-wallet', compact('user'));
    // }
    
    
     public function viewUserDetails($id) {
        $user = User::find($id);

        if (!$user) {
            return redirect()->route('admin.users.index')->with('error', 'User not found');
        }

        // Retrieve orders associated with the user
        $orders = Order::where('user_id', $id)->latest('created_at')->get();

        return view('admin.user.view-wallet', compact('user', 'orders'));
    }
    
    
     public function editUser($id = 0)
    {
        try {
            $user = User::find($id);
            if ($user) {
                return view('admin.user.edit', compact('user'));
            } else {
                // Handle the case where the user is not found.
                // You can return an error view or take appropriate action.
            }
        } catch (\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
     public function updateUser(Request $request,$id = 0)
    {

     $request->validate([
            'name' =>'required',
            'phone_number' =>'required',
            'email' =>'required',
            
        ],[
            'name.required' => 'Enter User Name',
            'phone_number.required' => 'Enter Phone Number',
            'email.required' => 'Enter Email',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                
                $data = User::find($id);
                $data->name = $request->name;
                $data->phone_number = $request->phone_number;
                $data->email = $request->email;
                if(!empty($request->password)){
                    $data->password = Hash::make($request->password);
                }
                
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('admin.list.user')->with('success','User Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    

    
    public function updateStatus(Request $request, $id)
    {
        $user = User::find($id);
    
        if (!$user) {
            return redirect()->back()->with('error', 'User not found.');
        }
    
        $action = $request->input('action');
    
        if ($action === 'activate') {
            $user->status = '1';
            $message = 'User has been activated.';
        } elseif ($action === 'deactivate') {
            $user->status = '0';
            $message = 'User has been deactivated.';
        } else {
            return redirect()->back()->with('error', 'Invalid action.');
        }
    
        $user->save();
    
        return redirect()->back()->with('success', $message);
    }
    
    
     public function updateCouponStatus(Request $request, $id)
    {
        $coupon = Coupon::find($id);
    
        if (!$coupon) {
            return redirect()->back()->with('error', 'User not found.');
        }
    
        $action = $request->input('action');
    
        if ($action === 'activate') {
            $coupon->is_active = '1';
            $message = 'User has been activated.';
        } elseif ($action === 'deactivate') {
            $coupon->is_active = '0';
            $message = 'User has been deactivated.';
        } else {
            return redirect()->back()->with('error', 'Invalid action.');
        }
    
        $coupon->save();
    
        return redirect()->back()->with('success', $message);
    }
    
    
     
      public function listSubCategory()
    {  
        try {
           
            $categories = Subcategory::leftJoin('categories','categories.id','=','subcategories.cat_id')
                                        ->select('subcategories.*','categories.name as category_name')
                                        ->get();

          return view('admin.subcategory.index',compact('categories'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function addSubCategory()
    {
        try {
            $category = Category::where('status',1)->pluck('name','id');
          return view('admin.subcategory.create',compact('category'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
  
    public function saveSubCategory(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|unique:subcategories',
            'cat_id'=> 'required'
            
        ],[
            'name.required' => 'Enter SubCategory Name',
            'name.max' => 'Max 255 Charactor ',
            'cat_id.required' => 'Please Select Category'
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $category = New Subcategory;
                $category->name = $request->name;
                $category->slug = $slug;
                $category->cat_id = $request->cat_id;
              

               

               if( $category->save()){
                     DB::commit();      
                    return redirect()->route('subcategory.list')->with('success','Sub Category Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editSubCategory($id =0 )
    {
         try {
           $category = Category::where('status',1)->pluck('name','id');
            $subcategory = Subcategory::find($id);

          return view('admin.subcategory.edit',compact('category','subcategory'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateSubCategory(Request $request,$id = 0)
    {

       $request->validate([
            'name' => 'required|max:255',
            
        ],[
            'name.required' => 'Enter Category Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                
                $category = Subcategory::find($id);
               $category->name = $request->name;
            $category->cat_id = $request->cat_id;

               
               if( $category->save()){
                     DB::commit();      
                    return redirect()->route('subcategory.list')->with('success','Sub Category Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    
    
    public function listFabric()
    {  
        try {
           
            $result = Fabric::latest()->get();

          return view('admin.fabric.index',compact('result'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function addFabric()
    {
        try {
        
          return view('admin.fabric.create');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
  
    public function saveFabric(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|unique:fabrics',
            
        ],[
            'name.required' => 'Enter Fabric Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $data = New Fabric;
                $data->name = $request->name;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('fabric.list')->with('success','Fabric Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editFabric($id =0 )
    {
         try {
           
            $fabric = Fabric::find($id);

          return view('admin.fabric.edit',compact('fabric'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateFabric(Request $request,$id = 0)
    {

       $request->validate([
            'name' => 'required|max:255',
            
        ],[
            'name.required' => 'Enter Fabric Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                
                $data = Fabric::find($id);
               $data->name = $request->name;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('fabric.list')->with('success','Fabric Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    
    
      
        public function listSize()
    {  
        try {
           
            $result = Size::latest()->get();

          return view('admin.size.index',compact('result'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function addSize()
    {
        try {
        
          return view('admin.size.create');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
  
    public function saveSize(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|unique:sizes',
            
        ],[
            'name.required' => 'Enter Size Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $data = New Size;
                $data->name = $request->name;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('size.list')->with('success','Size Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editSize($id =0 )
    {
         try {
           
            $data = Size::find($id);

          return view('admin.size.edit',compact('data'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateSize(Request $request,$id = 0)
    {

       $request->validate([
            'name' => 'required|max:255',
            
        ],[
            'name.required' => 'Enter Fabric Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                
                $data = Size::find($id);
               $data->name = $request->name;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('size.list')->with('success','Size Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
            public function listColor()
    {  
        try {
           
            $result = Color::latest()->get();

          return view('admin.color.index',compact('result'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function addColor()
    {
        try {
        
          return view('admin.color.create');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
  
    public function saveColor(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|unique:colors',
             'code' => 'required',
            
        ],[
            'name.required' => 'Enter Color Name',
            'name.max' => 'Max 255 Charactor ',
            'code.required' => 'Please Select Code',
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $data = New Color;
                $data->name = $request->name;
                $data->code = $request->code;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('color.list')->with('success','Color Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editColor($id =0 )
    {
         try {
           
            $data = Color::find($id);

          return view('admin.color.edit',compact('data'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateColor(Request $request,$id = 0)
    {

       $request->validate([
            'name' => 'required|max:255',
            'code' => 'required',
            
        ],[
            'name.required' => 'Enter Color Name',
            'name.max' => 'Max 255 Charactor ',
            'code.required' => 'Please Select Code',
            
        ]);
             DB::beginTransaction();
            try {
                
                $data = Color::find($id);
               $data->name = $request->name;
               $data->code = $request->code;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('color.list')->with('success','Color Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function listBanner()
    {  
        try {
           
            $result = Banner::latest()->get();

          return view('admin.banner.index',compact('result'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function addBanner()
    {
        try {
        
          return view('admin.banner.create');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
  
    public function saveBanner(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|unique:banners',
             'image' => 'required',
            
        ],[
            'name.required' => 'Enter Banner Name',
            'name.max' => 'Max 255 Charactor ',
            'image.required' => 'Please Select Image',
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $data = New Banner;
                $data->name = $request->name;
                $data->slug = $slug;
                $image = $request->file('image');
              if(isset($image) && !empty($image)){
                $imageName = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/banner');
                $image->move($destinationPath, $imageName);
                $imagePath = 'public/uploads/banner/'.$imageName;
                $data->image=$imagePath;
              }
               if(!empty($request->text_on_banner)){
                    $data->text_on_banner = $request->text_on_banner;
                }

               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('banner.list')->with('success','Banner Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editBanner($id =0 )
    {
         try {
           
            $data = Banner::find($id);
            $categories =Category::where('status',1)->get();
            $result = Product::where('status',1);
            
            $result = $result->get();
          return view('admin.banner.edit',compact('data','result','categories'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateBanner(Request $request,$id = 0)
    {

       $request->validate([
            'name' => 'required|max:255',
            
        ],[
            'name.required' => 'Enter Banner Name',
            'name.max' => 'Max 255 Charactor ',
        ]);
             DB::beginTransaction();
            try {
                
                $data = Banner::find($id);
               $data->name = $request->name;
                $image = $request->file('image');
              if(isset($image) && !empty($image)){
                $imageName = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/banner');
                $image->move($destinationPath, $imageName);
                $imagePath = 'public/uploads/banner/'.$imageName;
                $data->image=$imagePath;
              }
                 if(!empty($request->text_on_banner)){
                    $data->text_on_banner = $request->text_on_banner;
                }
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('banner.list')->with('success','Banner Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function updateBannerStatus($id = 0, $status=NULL){
         $data = Banner::where(['id'=>$id])->first();
        $data->status = $status;
       
        if($data->save()){
            return redirect()->route('banner.list')->with('success','Banner Status Updated Successfully');
        } else {
            return redirect()->back()->with('failed','Status Updation Faild. Please try again later');
        }
    }
    
    
        public function listSlider()
    {  
        try {
           
            $result = Slider::orderBy('sort_order','asc')->get();

          return view('admin.slider.index',compact('result'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function addSlider()
    {
        try {
        
            $category = Category::latest()->where('status',1)->get();
             $product =Product::latest()->where('status',1)->get();
          return view('admin.slider.create',compact('category','product'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
  
    public function saveSlider(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|unique:sliders',
             'image' => 'required',
             'sort_order' => 'required|unique:sliders',
            
        ],[
            'name.required' => 'Enter Banner Name',
            'name.max' => 'Max 255 Charactor ',
            'image.required' => 'Please Select Image',
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $data = New Slider;
                $data->name = $request->name;
                  $data->banner_type = $request->banner_type;
                   $data->sort_order = $request->sort_order;
                    $data->banner_for = $request->banner_for;
                  if($request->banner_type == 'category'){
                       $data->category_id = $request->category_id;
                  }else{
                       $data->product_id = $request->product_id;
                  }
                $data->slug = $slug;
                $image = $request->file('image');
              if(isset($image) && !empty($image)){
                $imageName = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/slider');
                $image->move($destinationPath, $imageName);
                $imagePath = 'public/uploads/slider/'.$imageName;
                $data->image=$imagePath;
                if($image->getClientOriginalExtension() == 'gif'){
                    $data->type="gif";
                }else{
                    $data->type="image";
                }
              }
              if(!empty($request->text_on_banner)){
                    $data->text_on_banner = $request->text_on_banner;
                }

               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('slider.list')->with('success','Slider Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editSlider($id =0 )
    {
         try {
           $category = Category::latest()->where('status',1)->get();
             $product =Product::latest()->where('status',1)->get();
            $data = Slider::find($id);

          return view('admin.slider.edit',compact('data','category','product'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateSlider(Request $request,$id = 0)
    {

       $request->validate([
            'name' => 'required|max:255',
            'sort_order' => 'required|unique:sliders,sort_order,' . $id,
            
        ],[
            'name.required' => 'Enter Slider Name',
            'name.max' => 'Max 255 Charactor ',
        ]);
             DB::beginTransaction();
            try {
                
                $data = Slider::find($id);
                $data->name = $request->name;
                $data->banner_type = $request->banner_type;
                 $data->banner_for = $request->banner_for;
                  if($request->banner_type == 'category'){
                       $data->category_id = $request->category_id;
                  }else{
                       $data->product_id = $request->product_id;
                  }
                   $data->sort_order = $request->sort_order;
                $image = $request->file('image');
              if(isset($image) && !empty($image)){
                $imageName = time().'.'.$image->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/slider');
                $image->move($destinationPath, $imageName);
                $imagePath = 'public/uploads/slider/'.$imageName;
                $data->image=$imagePath;
                 if($image->getClientOriginalExtension() == 'gif'){
                    $data->type="gif";
                }else{
                    $data->type="image";
                }
              }
               if(!empty($request->text_on_banner)){
                    $data->text_on_banner = $request->text_on_banner;
                }
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('slider.list')->with('success','Slider Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
  public function listOrders(Request $request)
{
    try {
        $startDate = $request->input('startDate');
        $endDate = $request->input('endDate');
        $orderStatus = $request->input('orderStatus');

        $query = Order::with('orderDetails.product', 'user')
            ->leftJoin('users', 'users.id', '=', 'orders.user_id')
            ->select('orders.*', 'users.name as userName');

        // Filter by start date and end date if provided
        if ($startDate && $endDate) {
            $query->whereBetween('orders.created_at', [$startDate, $endDate]);
        }

        // Filter by order status if provided
        if ($orderStatus) {
            $query->where('orders.order_status', $orderStatus);
        }

        $orders = $query->latest()->get();

        return view('admin.order.index', compact('orders'));
    } catch (\Exception $ex) {
        dd($ex->getMessage());
    }
}

   
    
    
//     public function listOrders()
// {
//     try {
//         $orders = Order::with('orderDetails.product', 'user')
//             ->leftJoin('users', 'users.id', '=', 'orders.user_id')
//             ->select('orders.*', 'users.name as userName')
//             ->latest()
//             ->get();

//         return view('admin.order.index', compact('orders'));
//     } catch (\Exception $ex) {
//         dd($ex->getMessage());
//     }
// }



public function UpdateorderStatus(Request $request, $id)
{
    $status = $request->input('status');

    $order = Order::find($id);

    if (!$order) {
        return redirect()->back()->with('error', 'Order not found.');
    }

    // Check if the order status is already "Cancelled"
    if ($order->order_status === 'Cancelled') {
        return redirect()->back()->with('error', 'Order status is already Cancelled and cannot be updated again.');
    }

    // Check if the status is being updated to "Cancelled"
    if ($status === 'Cancelled') {
        // Restore quantity for each product in the order back to stock
        foreach ($order->orderDetails as $orderDetail) {
            $productSize = ProductSize::find($orderDetail->product_size_id);
            if ($productSize) {
                $productSize->stock += $orderDetail->quantity;
                $productSize->save();
            }
        }
    }

    $order->update(['order_status' => $status]);

    // Update order details status
    foreach ($order->orderDetails as $orderDetail) {
        $orderDetail->update(['status' => $status]);
    }

    return redirect()->back()->with('success', 'Order status updated successfully.');
}




// public function UpdateorderStatus(Request $request, $id)
//     {
//       $status = $request->input('status'); 

//     $order = Order::find($id);

//     if (!$order) {
//         return redirect()->back()->with('error', 'Order not found.');
//     }

//     $order->update(['order_status' => $status]);
    
//     foreach ($order->orderDetails as $orderDetail) {
//         $orderDetail->update(['status' => $status]);
//     }

//         return redirect()->back()->with('success', 'Order status updated successfully.');
//     }





    
       public function orderDetail($id = 0)
    {  
         try {
               $orders = Order::where('id',$id)->with('order_details')->latest()->first();
            $Address = UserAddress::where('id',$orders->address_id)->first();
            return view('admin.order.detail')->with([
               'orders' => $orders,
               'customer_address' => $Address,
            ]);
          return view('admin.order.detail');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function listInvoices()
    {  
        try {
           
          return view('admin.invoice.index');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
        public function invoiceDetail($id = 0)
    {  
        try {
           
          return view('admin.invoice.detail');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
     
       
   
    
    // public function listUsers()
    // {  
    //     try {
           
    //       $startDate = $request->input('startDate');
    //       $endDate = $request->input('endDate');
    //       $userStatus = $request->input('userStatus');
           
    //         $result = User::where('type',0)->latest()->get();
            
    //          if ($startDate && $endDate) {
    //         $query->whereBetween('users.created_at', [$startDate, $endDate]);
    //     }

    //     // Filter by order status if provided
    //     if ($userStatus) {
    //         $query->where('users.status', $userStatus);
    //     }

    //       return view('admin.user.index',compact('result'));

    //     } catch(\Exception $ex) {
    //         dd($ex->getMessage());
    //     }
    // }
    
    public function listUsers(Request $request)
{  
    try {
        $startDate = $request->input('startDate');
        $endDate = $request->input('endDate');
        $userStatus = $request->input('userStatus');

        $query = User::where('type', 0)->latest();

        // Filter by start and end date if provided
        if ($startDate && $endDate) {
            $query->whereBetween('created_at', [$startDate, $endDate]);
        }

        // Filter by user status if provided
        if ($userStatus !== null) {
            $query->where('status', $userStatus);
        }

        $result = $query->get();

        return view('admin.user.index', compact('result'));

    } catch(\Exception $ex) {
        dd($ex->getMessage());
    }
}

        
    public function listCoupon()
    {  
        try {
           
            $result = Coupon::latest()->get();

          return view('admin.coupon.index',compact('result'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
     public function addCoupon()
    {
        try {
        
          return view('admin.coupon.create');

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
  
    public function saveCoupon(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255',
            'code' => 'required|unique:coupons',
            'percentage'   =>'required'          
            
        ],[
            'percentage.required' => 'Enter Coupon Percentage',
            'code.required' => 'Enter Coupon Code',
            'name.required' => 'Enter Coupon Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                  $slug =  Str::slug($request->name);

                $data = New Coupon;
                $data->name = $request->name;
                 $data->code = $request->code;
                  $data->percentage = $request->percentage;
                   $data->end_date = $request->end_date;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('coupon.list')->with('success','Coupon Added.');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
    public function editCoupon($id =0 )
    {
         try {
           
            $data = Coupon::find($id);

          return view('admin.coupon.edit',compact('data'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function updateCoupon(Request $request,$id = 0)
    {

        $request->validate([
            'name' => 'required|max:255',
            'code' => 'required|unique:coupons',
            'percentage'   =>'required'          
            
        ],[
            'percentage.required' => 'Enter Coupon Percentage',
            'code.required' => 'Enter Coupon Code',
            'name.required' => 'Enter Coupon Name',
            'name.max' => 'Max 255 Charactor ',
            
        ]);
             DB::beginTransaction();
            try {
                
                $data = Coupon::find($id);
                 $data->code = $request->code;
                  $data->percentage = $request->percentage;
                   $data->end_date = $request->end_date;
               if( $data->save()){
                     DB::commit();      
                    return redirect()->route('coupon.list')->with('success','Coupon Data Updated Successfully');
               }              
            } catch(\Exception $ex) {
                  echo $ex;die;
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
    
     public function listReels()
    {  
        try {
           $reelsData = Reel::leftJoin('users','users.id','=','reels.user_id')->select('reels.*','users.name as userName',DB::raw('GROUP_CONCAT(products.name) as product_names'))
            ->leftJoin('products', function ($join) {
                $join->on(DB::raw('FIND_IN_SET(products.id, reels.product_id)'), '>', DB::raw("'0'"));
            })
            ->groupBy('reels.id')
            ->get();
          return view('admin.reels.index',compact('reelsData'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
       public function listComingSoonData()
    {  
        try {
           $data = ComingSoon::leftJoin('products','products.id','=','coming_soons.product_id')->select('coming_soons.*','products.name as productName','products.sku_no as sku_no')
            ->get();
          return view('admin.coming_soon',compact('data'));

        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }
    
    
    public function updateReelsStatus($id = 0, $status=NULL){
         $data = Reel::where(['id'=>$id])->first();
        $data->is_approved = $status;
       
        if($data->save()){
            return redirect()->route('admin.list.reels')->with('success','Reel Status Updated Successfully');
        } else {
            return redirect()->back()->with('failed','Status Updation Faild. Please try again later');
        }
    }
    
    
      
    //  public function listReview()
    // {
    //     $pageName = 'Course Reviews';
    //     $data = Review::leftJoin('products','products.id','=','reviews.product_id')->leftJoin('users','users.id','=','reviews.user_id')
    //                     ->select('reviews.*','products.name as product_name','users.name as user_name','rating')->latest()->get();
    
    //     return view('admin.product.review',compact('data','pageName'));
    // }
  
 public function listReview()
{
    $pageName = 'Course Reviews';
    $data = Review::leftJoin('products','products.id','=','reviews.product_id')
                  ->leftJoin('users','users.id','=','reviews.user_id')
                  ->select('reviews.*','products.name as product_name','users.name as user_name') // Include the rating field
                  ->latest()
                  ->get();

    return view('admin.product.review', compact('data', 'pageName'));
}


    
       public function updateReviewStatus($id = 0, $status=NULL){
        $data = Review::where(['id'=>$id])->first();
        $data->status = $status;
        $getProductData = Product::where('id',$data->product_id)->first();
        $totalOfRating = $getProductData->average_rating * $getProductData->total_no_of_rating;
        $averageRating = (($totalOfRating) + ($data->rating)) / (($getProductData->total_no_of_rating) + 1);
        $getProductData->average_rating = ($averageRating);
        $getProductData->total_no_of_rating += 1;
        $getProductData->save();
        if($data->save()){
            return redirect()->route('admin.list.review')->with('success','Review Status updated successfully');
        } else {
            return redirect()->back()->with('failed','New Employee Created Faild. Please try again letter');
        }
    }
}
