<?php
   
namespace App\Http\Controllers\API;
   
use Illuminate\Http\Request;
use App\Http\Controllers\API\BaseController as BaseController;
use App\Models\User;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\Slider;
use App\Models\Banner;
use App\Models\Cart;
use App\Models\Wishlist;

use App\Models\Color;
use App\Models\Size;
use App\Models\Fabric;
use Illuminate\Support\Facades\Auth;
use Validator;
use Mail;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Hash;
   
class RegisterController extends BaseController
{
        /**
     * Register api
     *
     * @return \Illuminate\Http\Response
     */
       /**
     * Register api
     *
     * @return \Illuminate\Http\Response
     */
    public function registerDataApi(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'password' => 'required',
            'phone_number' => 'required|unique:users',
            'email' =>'required|email|unique:users'
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        
  
   
        $input = $request->all();
       
        $user = new User();
        $user->name = $input['name'];
        $user->email = $input['email'];
        $user->phone_number = $input['phone_number'];
        $user->type = config('global.USER');
        $user->password = Hash::make($input['password']);
        $user->save();
        $success['token'] =  $user->createToken('MyApp')->plainTextToken;
        $success['name'] =  $user->name;
   
        return $this->sendResponse($success, 'User register successfully.');
    }



    /**
     * Login api
     *
     * @return \Illuminate\Http\Response
     */
    public function login(Request $request)
    {
        
        if(Auth::attempt(['email' => $request->email, 'password' => $request->password])){ 
            
            $user = Auth::user(); 
            $user->device_id = $request->device_id;
            $user->save();
            if(!empty($request->random_id)){
                $getCartData = Cart::where('random_id',$request->random_id)->get();
               // echo '<pre/>';print_r($getCartData);die;
                $getWishlistData = Wishlist::where('random_id',$request->random_id)->get();
                if(!empty($getCartData)){
                    foreach($getCartData as $cartData){
                        $cartData->user_id = $user->id;
                        $cartData->random_id = null;
                        $cartData->save();
                        
                    }
                }
                
                if(!empty($getWishlistData)){
                    foreach($getWishlistData as $wishlistData){
                        $wishlistData->user_id = $user->id;
                        $wishlistData->random_id = null;
                        $wishlistData->save();
                        
                    }
                }
            }
            $success['token'] =  $user->createToken('MyApp')->plainTextToken; 
            $success['name'] =  $user->name;
   
            return $this->sendResponse($success, 'User login successfully.');
        } 
        else{ 
            return $this->sendError('Email-Address And Password Are Wrong.');
        } 
    }
    
    public function getCountries(Request $request){
     
           $countries = Country::get();
           if($countries){
               return $this->sendResponse($countries, 'States list');
           }else{
               return $this->sendError('Countries Not Exist In Database.');
           }
       
    }
    
    
    public function getStates(Request $request,$countryId=0){
     
           $states = State::where('country_id',$countryId)->get();
           if($states){
               return $this->sendResponse($states, 'States list');
           }else{
               return $this->sendError('States Not Exist In Database.');
           }
       
    }
    
    
       
    public function getSliderData(Request $request){
     
           $sliderData = Slider::where('status',1)->where('banner_for','mobile')->orderBy('sort_order','asc')->get();
           if($sliderData){
               return $this->sendResponse($sliderData, 'Slider Data list');
           }else{
               return $this->sendError('Slider Not Exist In Database.');
           }
       
    }
    
    
    
      public function getCategoryPageTopBannerData(Request $request){
     
           $bannerData = Banner::where('status',1)->where('type','category')->get();
           if($bannerData){
               return $this->sendResponse($bannerData, 'Category Banner Data list');
           }else{
               return $this->sendError('Banner Not Exist In Database.');
           }
       
    }
    
       public function getHomePageBannerData(Request $request){
     
           $bannerData = Banner::where('status',1)->where('type','home')->get();
           if($bannerData){
               return $this->sendResponse($bannerData, 'Home Banner Data list');
           }else{
               return $this->sendError('Banner Not Exist In Database.');
           }
       
    }
    
       public function getSwipePageBannerData(Request $request){
     
           $bannerData = Banner::where('status',1)->where('type','swipe')->get();
           if($bannerData){
               return $this->sendResponse($bannerData, 'Swipe Banner Data list');
           }else{
               return $this->sendError('Banner Not Exist In Database.');
           }
       
    }
    
       public function getLoginPageBannerData(Request $request){
     
           $bannerData = Banner::where('status',1)->where('type','login')->get();
           if($bannerData){
               return $this->sendResponse($bannerData, 'Login Page Banner Data list');
           }else{
               return $this->sendError('Banner Not Exist In Database.');
           }
       
    }
    
    
    
    
    
    
    
    public function getCities(Request $request,$stateId=0){
        
           $cities = City::where('state_id',$stateId)->get();
           if($cities){
               return $this->sendResponse($cities, 'Cities list');
           }else{
               return $this->sendError('Cities Not Exist In Database.');
           }
       
    }
    
    
      /**
     * check mobile exist api
     *
     * @return \Illuminate\Http\Response
     */
    public function sendOtpOnMail(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required',
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
   
        $input = $request->all();
       // $code = mt_rand(1000, 9999);
       $code = 1234;
        $userExist = User::where('email',$input['email'])->where('status',1)->first();
        if(!empty($userExist)){
            $userExist->reset_code = $code;
            $userExist->save();
            Mail::send('emails.send_otp', ['otp' => $code,'email'=>$userExist->email,'name'=>$userExist->name], function ($m) use ($userExist) {
                $m->from('tos@tossas.in', 'Reset Password Reminder!');
     
                $m->to($userExist->email, $userExist->name)->subject('Reset Password Reminder!');
            });   
            return $this->sendResponse([], 'Your otp send to your email.please enter and verify');
        }else{
            return $this->sendError('Doctor not found with this email');
        }
    }
    
    
    
     /**
     * Login api
     *
     * @return \Illuminate\Http\Response
     */
    public function checkOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'reset_code' =>'required',
            'email' =>'required'
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        $input = $request->all();
        $userData = User::where('email',$input['email'])->where('reset_code',$input['reset_code'])->where('status',1)->first();
        if($userData) {
            $success['reset_code'] =  $input['reset_code']; 
         
            return $this->sendResponse($success, 'Reset Password Code Valid.');
        }else{
            return $this->sendError('Unauthorised.', ['error'=>'Code Invalid']);
        }
         
    }
    
    
    
     public function passwordReset(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|exists:users',
             'password' => 'required|min:6|confirmed',
             'password_confirmation' => 'required'
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        $input = $request->all();
        $userData = User::where('email',$input['email'])->where('status',1)->first();
        if($userData) {
            $userData->password = Hash::make($input['password']);
            $userData->save();
         
            return $this->sendResponse($userData, 'Your Password Changed Successfully.');
        }else{
            return $this->sendError('Unauthorised.', ['error'=>'Doctor Not Exist']);
        }
         
    }
    
    
    
      public function getAllColors(Request $request){
     
           $colors = Color::get();
           if($colors){
               return $this->sendResponse($colors, 'Color list');
           }else{
               return $this->sendError('Color Not Exist In Database.');
           }
       
    }
    
    
      public function getAllSizes(Request $request){
     
           $sizes = Size::get();
           if($sizes){
               return $this->sendResponse($sizes, 'Size list');
           }else{
               return $this->sendError('Sizes Not Exist In Database.');
           }
       
    }
    
    
      public function getAllFabrics(Request $request){
     
           $fabrics = Fabric::get();
           if($fabrics){
               return $this->sendResponse($fabrics, 'Fabrics list');
           }else{
               return $this->sendError('Fabrics Not Exist In Database.');
           }
       
    }
    
    public function logout(Request $request)
    {
        auth()->user()->tokens()->delete();
        return $this->sendResponse([], 'User Logout successfully.');
    }
}