<?php


namespace App\Exports;
use Auth;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
    
    
class ExportVendor implements FromCollection, WithHeadings
{
 
     public function collection()
    {
        if(Auth::user()->type == config('global.LEARNING_PARTNER')){
           return User::leftJoin('users as userData','userData.id','=','users.company_id')->where('users.type',config('global.VENDOR'))->where('users.is_deleted',0)
                        ->where('users.company_id',Auth::user()->id)->select('users.name','users.email','userData.name as LPName','users.address','users.city','users.state','users.pincode')->get();
        }else{
            return User::leftJoin('users as userData','userData.id','=','users.company_id')->where('users.type',config('global.VENDOR'))->where('users.is_deleted',0)
                        ->select('users.name','users.email','users.address','users.city','users.state','users.pincode')->get();
        }
        

    }
    
    public function headings() :array
    {
        return["Name", "Email","Address","City","State","Pincode"];
    }
}