<?php


namespace App\Exports;
use Auth;
use App\Models\Booking;
use App\Models\Product;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
    
    
class ExportPurchasedCourse implements FromCollection, WithHeadings
{
 
    protected $type;
    public function __construct($type)
    {
      
        $this->type = $type;
    }
     public function collection()
    {
       
       $purchasedCourse = Booking::leftJoin('products','products.id','=','bookings.course_id')
                                    ->leftJoin('users','users.id','=','bookings.user_id')
                                    ->select('bookings.*','users.name as user_name','products.name as course_name');
                                    if(Auth::user()->type == config('global.LEARNING_PARTNER')){
                                        $companyProducts = Product::where('company_id',Auth::user()->id)->select("id")->get()->toArray();
                                        $purchasedCourse = $purchasedCourse->whereIn('bookings.course_id',$companyProducts);
                                    }else if(Auth::user()->type == config('global.VENDOR')){
                                        $purchasedCourse = $purchasedCourse->where('bookings.company_id', Auth::user()->id);
                                    }
        if($this->type == 'in_process'){
           $purchasedCourse = $purchasedCourse->where('result','in_process');
        }else if($this->type == 'Pass'){
             $purchasedCourse = $purchasedCourse->where('result','pass');
        }else if($this->type == 'Fail'){
             $purchasedCourse = $purchasedCourse->where('result','fail');
        }else if($this->type == 'certificate'){
            $purchasedCourse = $purchasedCourse->where('result_status','completed');
        }                            
         $purchasedCourse = $purchasedCourse->orderBy('id','desc')
                                    ->get();
         if(!empty($purchasedCourse)){
             $result = array();
               foreach($purchasedCourse as $userData){
                   
                       $type = "Direct User";
                   
                   
                   if($userData->result == "in_process"){
                       $uresult = "In Process";
                   }else if($userData->result == "Pass"){
                       $uresult = "Pass";
                   }else{
                       $uresult = "Fail";
                   }
                   $result[] = array(
                      'booking_id'=>$userData->id,
                      'order_id' => $userData->order_id,
                      'user_name' => $userData->user_name,
                      'type' => $type,
                      'course_name' => $userData->course_name,
                      'created_at' => $userData->created_at,
                      'amount' => $userData->amount,
                      'percentage' => $userData->percentage,
                      'result' => $uresult
                   );
                }
        
                return collect($result);
         }
    }
    
    public function headings() :array
    {
        return["Booking Id","#Order Id", "User Name","Vendor Name/User Type ","Product Name ","Purchase Date","Total Cost(INR)","Total Score","Pass/Fail"];
    }
}